/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.velocity;

import de.governikus.csl.uom.i18n.MessageFormatUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HTMLEscapingResourceBundle
extends ResourceBundle {
    private final ResourceBundle delegate;
    private static final String ZERO_WIDTH_SPACE = "&#x200B;";
    private static final String NO_BREAK_SPACE = "&#0160;";
    private static final String SOFT_HYPHEN = "&#xAD;";
    private static final String HARD_HYPHEN = "&#x2010;";
    private static final String URL_WRAPPING_CHARS = "/:?&_.";
    private static final Pattern HTML_ESCAPE_SEQUENCE_PATTERN = Pattern.compile("(&#\\d+;)|(&\\w+;)|(&#x[0-9A-Fa-f]+;)");

    public HTMLEscapingResourceBundle(ResourceBundle delegate) {
        this.delegate = delegate;
        this.setParent(delegate);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.delegate.getObject(key);
    }

    public String format(String key, Object ... args) {
        return this.format(key, this.getLocale(), args);
    }

    public static String format(ResourceBundle rb, String key, Object ... args) {
        return HTMLEscapingResourceBundle.format(rb, key, rb.getLocale(), args);
    }

    public String format(String key, Locale locale, Object ... args) {
        return HTMLEscapingResourceBundle.format((ResourceBundle)this, key, locale, args);
    }

    public static String format(ResourceBundle rb, String key, Locale locale, Object ... args) {
        return MessageFormatUtils.format((ResourceBundle)rb, (String)key, (boolean)false, (Object[])args);
    }

    public String getHTML(Object key) {
        return HTMLEscapingResourceBundle.escapeHTML(this.getString(key.toString()), false);
    }

    public String getHTMLWrapped(Object key) {
        return HTMLEscapingResourceBundle.escapeHTML(this.getString(key.toString()), true);
    }

    public String getHTML(Object key, Object ... parms) {
        return HTMLEscapingResourceBundle.escapeHTML(this.format(key.toString(), parms), false);
    }

    public String getHTMLWrapped(Object key, Object ... parms) {
        return HTMLEscapingResourceBundle.escapeHTML(this.format(key.toString(), parms), true);
    }

    public static String[] splitSections(String string) {
        if (string == null || string.length() == 0) {
            return new String[]{""};
        }
        StringBuilder sb = new StringBuilder(string.length());
        int lastChar = 0;
        for (int i = 0; i < string.length(); ++i) {
            char actChar = string.charAt(i);
            switch (actChar) {
                case '\\': {
                    if (lastChar != 92) break;
                    actChar = '\u0000';
                    sb.append('\\');
                    break;
                }
                case '\n': {
                    sb.append(lastChar == 92 ? "\\ " : " ");
                    break;
                }
                case 'n': {
                    sb.append(lastChar == 92 ? (char)'\n' : (char)actChar);
                    break;
                }
                default: {
                    if (actChar <= '\u001f') break;
                    HTMLEscapingResourceBundle.escapeHTML(sb, actChar, '\u0000');
                }
            }
            lastChar = actChar;
        }
        return sb.toString().split("\n");
    }

    public static Collection<String> escapeHTML(Collection<?> collection) {
        return collection.stream().map(collectionItem -> HTMLEscapingResourceBundle.escapeHTML(collectionItem)).collect(Collectors.toList());
    }

    public static String escapeHTML(Object string) {
        if (string == null) {
            return null;
        }
        String contentToEscape = string.toString();
        Matcher htmlEscapeSeqMatcher = HTML_ESCAPE_SEQUENCE_PATTERN.matcher(contentToEscape);
        if (htmlEscapeSeqMatcher.find()) {
            return contentToEscape;
        }
        return HTMLEscapingResourceBundle.escapeHTML(contentToEscape, false);
    }

    public static String escapeHTMLWrapped(Object string) {
        return HTMLEscapingResourceBundle.escapeHTML(string != null ? string.toString() : null, true);
    }

    public static String escapeHTMLWrappableURL(Object stringP) {
        return HTMLEscapingResourceBundle.escapeHTMLWrappableURL(stringP, SOFT_HYPHEN);
    }

    public static String escapeHTMLWrappableURL(Object stringP, String wrapper) {
        if (stringP == null) {
            return null;
        }
        String string = stringP.toString();
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(string.length());
        char lastChar = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char actChar = string.charAt(i);
            HTMLEscapingResourceBundle.escapeHTML(sb, actChar, lastChar);
            if (URL_WRAPPING_CHARS.indexOf(actChar) >= 0) {
                sb.append(wrapper);
            }
            lastChar = actChar;
        }
        return sb.toString();
    }

    private static String escapeHTML(Object stringP, boolean doWrap) {
        if (stringP == null) {
            return null;
        }
        String string = stringP.toString();
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(string.length());
        char lastChar = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char actChar = string.charAt(i);
            if (doWrap) {
                sb.append(ZERO_WIDTH_SPACE);
            }
            HTMLEscapingResourceBundle.escapeHTML(sb, actChar, lastChar);
            lastChar = actChar;
        }
        return sb.substring(doWrap ? ZERO_WIDTH_SPACE.length() : 0);
    }

    private static void escapeHTML(StringBuilder sb, char actChar, char lastChar) {
        switch (actChar) {
            case ' ': {
                sb.append(lastChar == ' ' ? NO_BREAK_SPACE : " ");
                break;
            }
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            case '>': {
                sb.append("&gt;");
                break;
            }
            case '\n': {
                sb.append("&lt;br&gt;");
                break;
            }
            default: {
                sb.append(actChar);
            }
        }
    }

    public String getDateTime(Date date) {
        return new SimpleDateFormat(this.getString("datetime.format.long"), this.getLocale()).format(date);
    }

    public String getISO8601DateString(Date date) {
        return this.getISO8601DateString(date, this.getLocale());
    }

    public String getISO8601DateString(Date date, Locale locale) {
        SimpleDateFormat sdfPDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", locale);
        String dateStr = sdfPDF.format(date);
        return dateStr.substring(0, dateStr.length() - 2) + ":" + dateStr.substring(dateStr.length() - 2);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.delegate.getKeys();
    }

    @Override
    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    @Override
    public String getBaseBundleName() {
        return this.delegate.getBaseBundleName();
    }

    public boolean isKey(Object object) {
        if (object != null && object instanceof String) {
            return this.containsKey((String)object);
        }
        return false;
    }
}

