/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.model;

import de.governikus.csl.inspect.model.PreprocessedTLInfo;
import de.governikus.csl.inspect.velocity.HTMLEscapingResourceBundle;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.CertificateQualificationInformation;
import de.governikus.csl.uom.validate.CertificateQualityResult;
import de.governikus.csl.uom.validate.QualityResult;
import de.governikus.csl.uom.validate.ServiceInfo;
import de.governikus.csl.uom.validate.TSPInfo;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validate.svp.CertificateQualityConstraints;
import de.governikus.csl.validation.quality.cert.model.constant.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public class PreprocessedQualityInformation {
    private static final String NAME_SUFFIX = ".name";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    static final List<String> CERT_QUALITY_DECISIVE_QUALIFIERS = new ArrayList<String>();
    static final List<String> CERT_QUALITY_DECISIVE_ASIS;
    static final List<String> CERT_QUALITY_DECISIVE_QCSTATEMENTS;
    static final List<String> CERT_QUALITY_DECISIVE_CERTPOLICIES;
    static final List<String> SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS;
    static final List<String> SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS;
    private String qualifiedCertificateTypePropertyKey;
    private PreprocessedTLInfo TSLInfo;
    private TSPInfo issuerTrustServiceProviderInformation;
    private ServiceInfo issuerServiceInfo;
    private Date serviceStatusDeterminationTime;
    private CertificateQualificationInformation qualityInformation;
    private QualityResult qualityResult;
    private CertificateQualityResult certQualityResult;
    private X509CertificateImpl certificate;
    private boolean beforeEidas;
    private de.governikus.csl.uom.validate.CertificateQualityConstraints allConstraints;
    private CertificateQualityConstraints certReportConstraints = new CertificateQualityConstraints();
    private CertificateQualityConstraints sigReportConstraints = new CertificateQualityConstraints();
    private boolean constraintsInitialited = false;

    public void setQualifiedCertificateTypePropertyKey(String qualifiedCertificateTypePropertyKey) {
        this.qualifiedCertificateTypePropertyKey = qualifiedCertificateTypePropertyKey;
    }

    public String getQualifiedCertificateTypePropertyKey() {
        return this.qualifiedCertificateTypePropertyKey;
    }

    public QualityResult getQualityResult() {
        return this.qualityResult;
    }

    public void setQualityResult(QualityResult qualityResult) {
        this.qualityResult = qualityResult;
        if (qualityResult != null) {
            this.certQualityResult = qualityResult.getCertificateQualityResult();
            if (this.certQualityResult != null) {
                this.allConstraints = this.certQualityResult.getConstraints();
                if (this.allConstraints != null && !this.constraintsInitialited) {
                    this.initFilteredConstraints();
                    this.constraintsInitialited = true;
                }
            }
        }
    }

    public CertificateQualityResult getCertQualityResult() {
        return this.certQualityResult;
    }

    public boolean isBeforeEidas() {
        return this.beforeEidas;
    }

    public de.governikus.csl.uom.validate.CertificateQualityConstraints getCertConstraints() {
        return this.allConstraints;
    }

    public CertificateQualityConstraints getCertReportConstraints() {
        return this.certReportConstraints;
    }

    public CertificateQualityConstraints getSigReportConstraints() {
        return this.sigReportConstraints;
    }

    public void setTSLInfo(PreprocessedTLInfo tslInfo) {
        this.TSLInfo = tslInfo;
    }

    public PreprocessedTLInfo getTSLInfo() {
        return this.TSLInfo;
    }

    public void setIssuerTrustServiceProviderInformation(TSPInfo trustServiceProviderInformation) {
        this.issuerTrustServiceProviderInformation = trustServiceProviderInformation;
    }

    public TSPInfo getIssuerTrustServiceProviderInformation() {
        return this.issuerTrustServiceProviderInformation;
    }

    public void setIssuerServiceInfo(ServiceInfo serviceInfo) {
        this.issuerServiceInfo = serviceInfo;
    }

    public ServiceInfo getIssuerServiceInfo() {
        return this.issuerServiceInfo;
    }

    public Date getServiceStatusDeterminationTime() {
        return this.serviceStatusDeterminationTime;
    }

    public void setServiceStatusDeterminationTime(Date serviceStatusDeterminationTime) {
        this.serviceStatusDeterminationTime = serviceStatusDeterminationTime;
    }

    public void setQualityInformation(CertificateQualificationInformation qualityInformation) {
        this.qualityInformation = qualityInformation;
    }

    public CertificateQualificationInformation getQualityInformation() {
        return this.qualityInformation;
    }

    public void setCertificate(X509CertificateImpl certificate) {
        this.certificate = certificate;
        this.beforeEidas = certificate.getNotBefore().before(Constants.EIDAS_START);
    }

    public X509CertificateImpl getCertificate() {
        return this.certificate;
    }

    public boolean hasCertificateQualityInformation() {
        return this.getQualityInformation() != null && this.getQualityInformation().getCertificateType() != null && this.getCertificate() != null;
    }

    public boolean hasCertificatePoliciesInformation() {
        if (this.hasCertificateQualityInformation()) {
            return this.getCertificate().getCertificatePolicies() != null && !this.getCertificate().getCertificatePolicies().isEmpty();
        }
        return false;
    }

    public boolean hasCertificateQcStatements() {
        if (this.hasCertificateQualityInformation()) {
            return this.getCertificate().getQCStatements() != null && !this.getCertificate().getQCStatements().isEmpty();
        }
        return false;
    }

    private void addOnCondition(boolean condition, List<String> list, String value) {
        if (condition) {
            list.add(value);
        }
    }

    public List<String> getCertificateQualityInfoList() {
        ArrayList<String> certQualityInfoList = new ArrayList<String>();
        X509CertificateImpl cert = this.getCertificate();
        if (cert == null || !this.hasCertificateQualityInformation()) {
            return certQualityInfoList;
        }
        List certTypes = cert.getEUQualifiedCertificateTypes();
        for (EUQualifiedCertificateType certType : certTypes) {
            certQualityInfoList.add(certType.getClass().getName() + "." + certType.name());
        }
        if (this.hasCertificateQcStatements()) {
            this.addOnCondition(cert.hasQCComplianceStatement(), certQualityInfoList, "signature.quality.cert.qcc");
            this.addOnCondition(cert.hasQCSSCDStatement(), certQualityInfoList, "signature.quality.cert.qcsscd");
        }
        if (this.hasCertificatePoliciesInformation()) {
            this.addOnCondition(cert.hasQCPSSCDPolicy(), certQualityInfoList, "signature.quality.cert.qcpsscdpolicy");
            this.addOnCondition(cert.hasQCPPolicy(), certQualityInfoList, "signature.quality.cert.qcppolicy");
            this.addOnCondition(cert.hasQCPPolicyIdentifiers(), certQualityInfoList, "signature.quality.cert.qcpmain");
            this.addOnCondition(cert.hasQCPNPolicy(), certQualityInfoList, "signature.quality.cert.qcpnpolicy");
            this.addOnCondition(cert.hasQCPLPolicy(), certQualityInfoList, "signature.quality.cert.qcplpolicy");
            this.addOnCondition(cert.hasQCPNQSCDPolicy(), certQualityInfoList, "signature.quality.cert.qcpnqscdpolicy");
            this.addOnCondition(cert.hasQCPLQSCDPolicy(), certQualityInfoList, "signature.quality.cert.qcplqscdpolicy");
            this.addOnCondition(cert.hasQCPWPolicy(), certQualityInfoList, "signature.quality.cert.qcpwpolicy");
        }
        return certQualityInfoList;
    }

    public List<String> getFilteredQualifierURIs(List<String> qualifierFilter) {
        return this.getFilteredList(this.allConstraints.getQualifiers(), qualifierFilter, String::new);
    }

    public List<String> getFilteredAdditionalServiceInformationURIs(List<String> asiFilter) {
        return this.getFilteredList(this.allConstraints.getAdditionalServiceInformations(), asiFilter, String::new);
    }

    public List<String> getFilteredQcStatementOIDs(List<String> qcStatementFilter) {
        return this.getFilteredList(this.allConstraints.getQCStatements(), qcStatementFilter, String::new);
    }

    public List<String> getFilteredPolicyOIDs(List<String> policyFilter) {
        return this.getFilteredList(this.allConstraints.getCertificatePolicies(), policyFilter, String::new);
    }

    public <T> List<String> getFilteredList(List<String> src, List<T> filter, Function<String, T> converter) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String srcItem : src) {
            if (!filter.contains(converter.apply(srcItem))) continue;
            filtered.add(srcItem);
        }
        return filtered;
    }

    private void copyConstraints(CertificateQualityConstraints src, CertificateQualityConstraints dst) {
        dst.setServiceTypeIdentifier(src.getServiceTypeIdentifier());
        dst.getQCStatements().addAll(src.getQCStatements());
        dst.getCertificatePolicies().addAll(src.getCertificatePolicies());
        dst.getQualifiers().addAll(src.getQualifiers());
        dst.getAdditionalServiceInformations().addAll(src.getAdditionalServiceInformations());
    }

    private void initFilteredConstraints() {
        this.getFilteredQcStatementOIDs(CERT_QUALITY_DECISIVE_QCSTATEMENTS);
        this.certReportConstraints.setServiceTypeIdentifier(this.allConstraints.getServiceTypeIdentifier());
        this.certReportConstraints.getQCStatements().addAll(this.getFilteredQcStatementOIDs(CERT_QUALITY_DECISIVE_QCSTATEMENTS));
        this.certReportConstraints.getQualifiers().addAll(this.getFilteredQualifierURIs(CERT_QUALITY_DECISIVE_QUALIFIERS));
        this.certReportConstraints.getAdditionalServiceInformations().addAll(this.getFilteredAdditionalServiceInformationURIs(CERT_QUALITY_DECISIVE_ASIS));
        this.certReportConstraints.getCertificatePolicies().addAll(this.getFilteredPolicyOIDs(CERT_QUALITY_DECISIVE_CERTPOLICIES));
        this.copyConstraints(this.certReportConstraints, this.sigReportConstraints);
        this.sigReportConstraints.getQCStatements().addAll(this.getFilteredQcStatementOIDs(Collections.singletonList("0.4.0.1862.1.4")));
        if (this.beforeEidas) {
            this.sigReportConstraints.getQualifiers().addAll(this.getFilteredQualifierURIs(SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS));
        } else {
            this.sigReportConstraints.getQualifiers().addAll(this.getFilteredQualifierURIs(SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS));
        }
    }

    public Pair<String, String> getNameAndDescription(HTMLEscapingResourceBundle rb, String item, Object ... param) {
        String defaultValue = "value.unknown";
        String itemName = item + NAME_SUFFIX;
        itemName = !rb.containsKey(itemName) ? rb.getString(defaultValue) : rb.getString(itemName);
        String itemDesc = item + DESCRIPTION_SUFFIX;
        itemDesc = rb.containsKey(itemDesc) ? (param != null && param.length > 0 ? rb.format(itemDesc, param) : rb.getString(itemDesc)) : rb.getString(defaultValue);
        return Pair.of((Object)itemName, (Object)itemDesc);
    }

    static {
        CERT_QUALITY_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/NotQualified");
        CERT_QUALITY_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCStatement");
        CERT_QUALITY_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig");
        CERT_QUALITY_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal");
        CERT_QUALITY_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA");
        CERT_QUALITY_DECISIVE_ASIS = new ArrayList<String>();
        CERT_QUALITY_DECISIVE_ASIS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures");
        CERT_QUALITY_DECISIVE_ASIS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals");
        CERT_QUALITY_DECISIVE_ASIS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication");
        CERT_QUALITY_DECISIVE_QCSTATEMENTS = new ArrayList<String>();
        CERT_QUALITY_DECISIVE_QCSTATEMENTS.add("0.4.0.1862.1.1");
        CERT_QUALITY_DECISIVE_QCSTATEMENTS.add("0.4.0.1862.1.6.2");
        CERT_QUALITY_DECISIVE_QCSTATEMENTS.add("0.4.0.1862.1.6.1");
        CERT_QUALITY_DECISIVE_QCSTATEMENTS.add("0.4.0.1862.1.6.3");
        CERT_QUALITY_DECISIVE_CERTPOLICIES = new ArrayList<String>();
        CERT_QUALITY_DECISIVE_CERTPOLICIES.add("0.4.0.1456.1.2");
        CERT_QUALITY_DECISIVE_CERTPOLICIES.add("0.4.0.1456.1.1");
        SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS = new ArrayList<String>();
        SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD");
        SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert");
        SIG_QUALITY_PRE_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD");
        SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS = new ArrayList<String>();
        SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD");
        SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf");
        SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert");
        SIG_QUALITY_POST_EIDAS_DECISIVE_QUALIFIERS.add("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD");
    }
}

