/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.model;

import de.governikus.csl.inspect.model.PreProcessedOsciDocument;
import de.governikus.csl.inspect.model.PreprocessedAsicDocument;
import de.governikus.csl.inspect.model.PreprocessedDeMailDocument;
import de.governikus.csl.inspect.model.PreprocessedDocument;
import de.governikus.csl.inspect.model.PreprocessedPdfDocument;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.validate.svp.AcknowledgeMessageValidationResult;
import de.governikus.csl.validate.svp.AsicDocumentValidationResult;
import de.governikus.csl.validate.svp.DeMailConfirmationValidationResult;
import de.governikus.csl.validate.svp.DeMailMimeDocumentValidationResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;

public class PreprocessedDocumentFactory {
    private PreprocessedDocumentFactory() {
    }

    public static PreprocessedDocument createDocument(ObjectValidationResult result) {
        if (result instanceof AsicDocumentValidationResult) {
            return new PreprocessedAsicDocument((AsicDocumentValidationResult)result);
        }
        if (result instanceof PAdESDocumentValidationResult) {
            return new PreprocessedPdfDocument((PAdESDocumentValidationResult)result);
        }
        if (result instanceof DeMailConfirmationValidationResult || result instanceof DeMailMimeDocumentValidationResult || result instanceof AcknowledgeMessageValidationResult) {
            return new PreprocessedDeMailDocument(result);
        }
        if (result instanceof OSCIDocumentValidationResult) {
            return new PreProcessedOsciDocument((OSCIDocumentValidationResult)result);
        }
        return new PreprocessedDocument(result);
    }
}

