/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import de.governikus.csl.uom.output.OutputPlugin;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityEngineSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(VelocityEngineSingleton.class);
    private static final String LOADER_TYPE = "classpath";
    private static final Map<String, VelocityEngine> pluginInstanceSingletonMap = new HashMap<String, VelocityEngine>();
    private static String GOV_VM_MAX_DEPTH = "gov.val.velocimacro.max_depth";
    public static final int MIN_RECURSION_LVL = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static VelocityEngine getInstance(OutputPlugin plugin) {
        String pluginClassName = plugin.getClass().getName();
        VelocityEngine engine = pluginInstanceSingletonMap.get(pluginClassName);
        if (engine == null) {
            Map<String, VelocityEngine> map = pluginInstanceSingletonMap;
            synchronized (map) {
                engine = pluginInstanceSingletonMap.get(pluginClassName);
                if (engine == null) {
                    engine = VelocityEngineSingleton.createNewInstance();
                    pluginInstanceSingletonMap.put(pluginClassName, engine);
                }
            }
        }
        return engine;
    }

    protected static VelocityEngine createNewInstance() {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loaders", (Object)LOADER_TYPE);
        engine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        engine.setProperty("resource.loader.classpath.cache", (Object)Boolean.TRUE);
        engine.setProperty("context.scope_control.macro", (Object)Boolean.TRUE);
        engine.setProperty("velocimacro.max_depth", (Object)VelocityEngineSingleton.getMaxRecursionLevel());
        engine.setProperty("introspector.conversion_handler.class", (Object)"none");
        engine.setProperty("directive.if.empty_check", (Object)Boolean.FALSE);
        engine.setProperty("parser.space_gobbling", (Object)RuntimeConstants.SpaceGobbling.STRUCTURED.name());
        engine.setProperty("velocimacro.enable_bc_mode", (Object)Boolean.TRUE);
        engine.init();
        return engine;
    }

    private static String getMaxRecursionLevel() {
        try {
            int systemEnvironmentValue;
            int n = systemEnvironmentValue = System.getProperty(GOV_VM_MAX_DEPTH) != null ? Integer.parseInt(System.getProperty(GOV_VM_MAX_DEPTH)) : -1;
            if (systemEnvironmentValue > -1 && systemEnvironmentValue < 200 && LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("System property '%s' value is too low (%d). Using default value: %d", GOV_VM_MAX_DEPTH, systemEnvironmentValue, 200));
            }
            int maxRecursionLevel = Math.max(systemEnvironmentValue, 200);
            return Integer.toString(maxRecursionLevel);
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("System property '%s' has no valid Integer value (%s). Using default value: %d", GOV_VM_MAX_DEPTH, System.getProperty(GOV_VM_MAX_DEPTH), 200));
            }
            return Integer.toString(200);
        }
    }
}

