/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import de.governikus.csl.inspect.common.ValidityModelInformation;
import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ValidityModelResolver
extends ObjectValidationResultVisitor<ObjectValidationResult> {
    private boolean timestampMode = false;
    private Stack<IntPtr> certLocation = new Stack();
    private List<ValidityModelInformation> validityModelInformation;

    public ValidityModelResolver() {
        this.certLocation.push(new IntPtr());
        this.validityModelInformation = new ArrayList<ValidityModelInformation>();
    }

    public void startVisitingCertificateValidationResult(PublicKeyCertificateValidationResult s) {
        IntPtr peek = this.certLocation.peek();
        ++peek.number;
        ValidityModelDeterminationResult validityModel = s.getValidityModel();
        if (validityModel != null) {
            ValidityModelInformation info = new ValidityModelInformation();
            info.setValidityModel(validityModel);
            info.setSubjectName(s.getCert().getSubjectX500Principal().toString());
            this.validityModelInformation.add(info);
        }
    }

    public void stopVisitingSignatureTimestampValidationResult(TimestampValidationResult tsr) {
        super.stopVisitingSignatureTimestampValidationResult(tsr);
        this.timestampMode = false;
    }

    public void startVisitingSignatureTimestampValidationResult(TimestampValidationResult tsr) {
        super.startVisitingSignatureTimestampValidationResult(tsr);
        this.timestampMode = true;
    }

    public void startVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        super.startVisitingRevocationValueValidationResult(revocationValueValidationResult);
        this.certLocation.push(new IntPtr());
    }

    public void stopVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        super.stopVisitingRevocationValueValidationResult(revocationValueValidationResult);
        this.certLocation.pop();
    }

    public List<ValidityModelInformation> getValidityModelInformation() {
        return this.validityModelInformation;
    }

    private class IntPtr {
        int number;

        private IntPtr() {
        }
    }
}

