/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.Flattable;
import de.governikus.CompInfo.ComponentInfo;
import de.governikus.csl.core.impl.CumulatedValidationResultImpl;
import de.governikus.csl.inspect.model.AlgorithmCatalogWrapper;
import de.governikus.csl.inspect.model.BaseResult;
import de.governikus.csl.inspect.model.BaseValidationResult;
import de.governikus.csl.inspect.model.CertInfo;
import de.governikus.csl.inspect.model.PolicyReference;
import de.governikus.csl.inspect.model.PreProcessedRevocationValueResult;
import de.governikus.csl.inspect.model.PreprocessValidatorInfo;
import de.governikus.csl.inspect.model.PreprocessedArchiveTimestampResult;
import de.governikus.csl.inspect.model.PreprocessedAttributeCertificateResultList;
import de.governikus.csl.inspect.model.PreprocessedCertificateList;
import de.governikus.csl.inspect.model.PreprocessedCertificateResult;
import de.governikus.csl.inspect.model.PreprocessedDocument;
import de.governikus.csl.inspect.model.PreprocessedDocumentFactory;
import de.governikus.csl.inspect.model.PreprocessedERSBackedTimestampChainResult;
import de.governikus.csl.inspect.model.PreprocessedEvidenceRecordValidationResult;
import de.governikus.csl.inspect.model.PreprocessedQualityInformation;
import de.governikus.csl.inspect.model.PreprocessedSignatureIntegrityResult;
import de.governikus.csl.inspect.model.PreprocessedSignatureResult;
import de.governikus.csl.inspect.model.PreprocessedSignatureValidationResult;
import de.governikus.csl.inspect.model.PreprocessedTLInfo;
import de.governikus.csl.inspect.model.PreprocessedTechnicalInformation;
import de.governikus.csl.inspect.model.PreprocessedTimestampChainResult;
import de.governikus.csl.inspect.model.PreprocessedTimestampResult;
import de.governikus.csl.inspect.model.PreprocessedTimestampValidationReport;
import de.governikus.csl.inspect.model.PreprocessedValidationReport;
import de.governikus.csl.inspect.model.RevocationValueType;
import de.governikus.csl.inspect.velocity.VelocityHelper;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.Principal;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.AlgorithmValidityResult;
import de.governikus.csl.uom.validate.AttributeCertificateValidationResult;
import de.governikus.csl.uom.validate.CertificateValidationResult;
import de.governikus.csl.uom.validate.ContainerValidationResult;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.EvaluatedValidatePolicy;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.QualityResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.ServiceInfo;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TLInfo;
import de.governikus.csl.uom.validate.TSPInfo;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.utils.SignatureAttributesUtils;
import de.governikus.csl.validate.svp.AdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validate.svp.CommitmentTypeIndicationType;
import de.governikus.csl.validate.svp.DigestAlgorithmValidityInformation;
import de.governikus.csl.validate.svp.ERArchiveTimestampChainValidationResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validate.svp.ERSValidationResult;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.ForwardedCVSInfo;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SigPolicyIdentifierType;
import de.governikus.csl.validate.svp.SignReasonType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignerLocationType;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.XAIPContainerValidationResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import lombok.NonNull;

public class ValidationReportPreProcessor {
    private List<PreprocessedTLInfo> trustedLists = new ArrayList<PreprocessedTLInfo>();
    private List<PreprocessedTLInfo> lotls = new ArrayList<PreprocessedTLInfo>();
    private Map<Integer, PolicyReference> policies = new HashMap<Integer, PolicyReference>();
    private Map<AlgorithmCatalogMetaInformation, AlgorithmCatalogWrapper> algorithmCatalogs = new HashMap<AlgorithmCatalogMetaInformation, AlgorithmCatalogWrapper>();
    private long nextID = 1L;
    private int nextTSID = 0;
    private ResourceBundle rbCert;
    private ResourceBundle rb;
    private PreprocessValidatorInfo validatorInfo;
    private long cumulatedRequestDuration = 0L;
    private boolean shortCertInfo = false;
    private boolean multiplyLtaAndErsWhenPresent = false;

    public boolean isMultiplyLtaAndErsWhenPresent() {
        return this.multiplyLtaAndErsWhenPresent;
    }

    public void setMultiplyLtaAndErsWhenPresent(boolean multiplyLtaAndErsWhenPresent) {
        this.multiplyLtaAndErsWhenPresent = multiplyLtaAndErsWhenPresent;
    }

    public ValidationReportPreProcessor(ResourceBundle rb, ResourceBundle rbCert) {
        this(rb, rbCert, false);
    }

    public ValidationReportPreProcessor(ResourceBundle rb, ResourceBundle rbCert, boolean shortCertInfo) {
        this.rbCert = rbCert;
        this.rb = rb;
        this.validatorInfo = new PreprocessValidatorInfo();
        this.shortCertInfo = shortCertInfo;
    }

    public PreprocessedValidationReport process(ValidateResponse validateResponse, ObjectValidationResult validationResult) {
        PreprocessedValidationReport report = new PreprocessedValidationReport();
        PreprocessedTechnicalInformation technicalInfo = this.processTechnicalInfo(validationResult);
        report.setTechnicalInformation(technicalInfo);
        report.setObjectTypeID(validationResult.getObjectTypeID());
        report.setObjectName(validationResult.getObjectName());
        List<PreprocessedSignatureResult> signatures = this.process(validationResult, report);
        report.setSignatures(signatures);
        List<PreprocessedEvidenceRecordValidationResult> documentEvidenceRecords = this.processDocumentEvidenceRecords(validationResult);
        report.setDocumentEvidenceRecords(documentEvidenceRecords);
        this.validatorInfo.setCumulatedRevocationRequestDuration(this.cumulatedRequestDuration);
        report.setStructure(this.createDocumentStructure(validationResult));
        report.setCreationTime(new Date());
        return report;
    }

    private PreprocessedDocument createDocumentStructure(ObjectValidationResult validationResult) {
        List signatureValidationResults;
        PreprocessedDocument doc = PreprocessedDocumentFactory.createDocument(validationResult);
        this.addChildren(doc, doc::getIncludedFileValidationResults, () -> ((ObjectValidationResult)validationResult).getIncludedFileValidationResults());
        if (validationResult instanceof ContainerValidationResult) {
            ContainerValidationResult containerResult = (ContainerValidationResult)validationResult;
            this.addChildren(doc, doc::getResultsForContainedObjects, () -> ((ContainerValidationResult)containerResult).getResultsForContainedObjects());
        }
        if ((signatureValidationResults = validationResult.getSignatureValidationResults()) != null && !signatureValidationResults.isEmpty()) {
            doc.setSignatureValidationResults(signatureValidationResults);
            doc.setContainingSignatureResult(true);
        }
        return doc;
    }

    private void addChildren(PreprocessedDocument doc, Supplier<List<PreprocessedDocument>> docChildrenGetter, Supplier<List<? extends ObjectValidationResult>> childValidationResultsGetter) {
        List<? extends ObjectValidationResult> childResults = childValidationResultsGetter.get();
        if (childResults != null && !childResults.isEmpty()) {
            List<PreprocessedDocument> docChildren = docChildrenGetter.get();
            for (ObjectValidationResult objectValidationResult : childResults) {
                PreprocessedDocument preProcessedChildResult = this.createDocumentStructure(objectValidationResult);
                docChildren.add(preProcessedChildResult);
                if (!preProcessedChildResult.isContainingSignatureResult()) continue;
                doc.setContainingSignatureResult(true);
            }
        }
    }

    private List<PreprocessedEvidenceRecordValidationResult> processDocumentEvidenceRecords(ObjectValidationResult validationResult) {
        if (validationResult instanceof XAIPContainerValidationResult) {
            List docERSValidationResults = ((XAIPContainerValidationResult)validationResult).getEvidenceRecordValidationResults();
            return this.processEvidenceRecords(docERSValidationResults);
        }
        return null;
    }

    private PreprocessedTechnicalInformation processTechnicalInfo(ObjectValidationResult validationResult) {
        PreprocessedTechnicalInformation technical = new PreprocessedTechnicalInformation();
        List<PolicyReference> processedPolicies = this.processPolicies(validationResult.getPolicies());
        technical.setPolicies(processedPolicies);
        technical.setTrustedLists(this.trustedLists);
        technical.setAlgorithmCatalogs(this.algorithmCatalogs.values());
        technical.setLotls(this.lotls);
        ComponentInfo ci = new ComponentInfo("csl_inspect_html.version");
        this.validatorInfo.setCslVersion(ci.getComponentVersion() != null ? ci.getComponentVersion() : "Untagged Version");
        technical.setValidatorInfo(this.validatorInfo);
        return technical;
    }

    private List<PolicyReference> processPolicies(Map<Integer, ? extends EvaluatedValidatePolicy> policies) {
        if (policies == null) {
            return null;
        }
        ArrayList<PolicyReference> result = new ArrayList<PolicyReference>();
        for (Map.Entry<Integer, ? extends EvaluatedValidatePolicy> entry : policies.entrySet()) {
            Integer id = entry.getKey();
            EvaluatedValidatePolicy policy = entry.getValue();
            PolicyReference ref = new PolicyReference();
            ref.setUid(this.createUniqueID("policy"));
            ref.setNr(id);
            if (policy != null) {
                PolicyInformation policyInformation = policy.getPolicy().getPolicyInformation();
                ref.setPolicyName(VelocityHelper.getPolicyName(this.rb, policyInformation));
                ref.setPolicy(policy);
                if (policyInformation != null) {
                    ref.setAuthor(policyInformation.getAuthor());
                    ref.setVersion(policyInformation.getVersion());
                }
            }
            result.add(ref);
            this.policies.put(id, ref);
        }
        Collections.sort(result, (x, y) -> x.getNr() - y.getNr());
        return result;
    }

    private List<PreprocessedSignatureResult> process(ObjectValidationResult validationResult, PreprocessedValidationReport report) {
        ContainerValidationResult ctr;
        List resultsForContainedObjects;
        List includedFileValidationResults;
        ArrayList<PreprocessedSignatureResult> result = new ArrayList<PreprocessedSignatureResult>();
        List<PreprocessedSignatureResult> signatures = this.processSignatures(validationResult);
        if (signatures != null) {
            result.addAll(signatures);
        }
        if ((includedFileValidationResults = validationResult.getIncludedFileValidationResults()) != null) {
            for (ObjectValidationResult res : includedFileValidationResults) {
                signatures = this.process(res, report);
                if (signatures == null) continue;
                result.addAll(signatures);
            }
        }
        if (validationResult instanceof ContainerValidationResult && (resultsForContainedObjects = (ctr = (ContainerValidationResult)validationResult).getResultsForContainedObjects()) != null) {
            for (ObjectValidationResult res : resultsForContainedObjects) {
                signatures = this.process(res, report);
                if (signatures == null) continue;
                result.addAll(signatures);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private List<PreprocessedSignatureResult> processSignatures(ObjectValidationResult validationResult) {
        List signatureValidationResults = validationResult.getSignatureValidationResults();
        if (signatureValidationResults == null) {
            return null;
        }
        ArrayList<PreprocessedSignatureResult> signatureReports = new ArrayList<PreprocessedSignatureResult>();
        for (SignatureValidationResult sig : signatureValidationResults) {
            PreprocessedSignatureResult signatureResult = null;
            signatureResult = sig instanceof de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult ? this.processX509AsSignature((de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult)sig) : (sig instanceof de.governikus.csl.uom.validate.TimestampValidationResult ? this.processStandaloneTimestamp((de.governikus.csl.uom.validate.TimestampValidationResult)sig) : this.processSignature(sig));
            signatureResult.setContentNames(sig.getContentNames());
            signatureResult.setDocumentObjectName(validationResult.getObjectName());
            signatureResult.setDocumentObjectTypeID(validationResult.getObjectTypeID());
            signatureResult.setUid(this.createUniqueID("signatureResult"));
            signatureResult.setValidationStartTime(sig.getValidationStartTime());
            signatureReports.add(signatureResult);
            if (!(sig instanceof AdESSignatureValidationResult)) continue;
            ArrayList<PreprocessedSignatureResult> counterSignatureResults = new ArrayList<PreprocessedSignatureResult>();
            this.processAdesCounterSignatures((AdESSignatureValidationResult)sig, signatureResult, counterSignatureResults);
            signatureReports.addAll(counterSignatureResults);
        }
        return signatureReports;
    }

    private void processAdesCounterSignatures(AdESSignatureValidationResult adesParentSig, PreprocessedSignatureResult adesSignatureResult, List<PreprocessedSignatureResult> counterSignatureList) {
        List counterSignatureValidationResults = adesParentSig.getCounterSignatureValidationResults();
        for (SignatureValidationResult sig : counterSignatureValidationResults) {
            PreprocessedSignatureResult signatureResult = this.processSignature(sig);
            signatureResult.setParentResult(adesSignatureResult);
            signatureResult.setContentNames(sig.getContentNames());
            signatureResult.setDocumentObjectName(adesSignatureResult.getDocumentObjectName());
            signatureResult.setDocumentObjectTypeID(adesSignatureResult.getDocumentObjectTypeID());
            signatureResult.setUid(this.createUniqueID("counterSignatureResult"));
            counterSignatureList.add(signatureResult);
            if (!(sig instanceof AdESSignatureValidationResult)) continue;
            this.processAdesCounterSignatures((AdESSignatureValidationResult)sig, signatureResult, counterSignatureList);
        }
    }

    private PreprocessedSignatureResult processX509AsSignature(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult sig) {
        List attributeCertificateValidationResults;
        PreprocessedSignatureResult result = new PreprocessedSignatureResult();
        X509CertificateImpl cert = sig.getCert();
        CertInfo signerInfo = this.getCertInfo(sig, cert);
        result.setSignerInfo(signerInfo);
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult issuerCertificateValidationResult = sig.getSigningCertificateValidationResult();
        if (issuerCertificateValidationResult != null) {
            CertInfo issuerInfo = this.getCertInfo(issuerCertificateValidationResult, issuerCertificateValidationResult.getCert());
            result.setIssuerInfo(issuerInfo);
        }
        if ((attributeCertificateValidationResults = sig.getAttributeCertificateValidationResults()) != null && !attributeCertificateValidationResults.isEmpty()) {
            ArrayList<CertInfo> attributeCertInfos = new ArrayList<CertInfo>();
            for (AttributeCertificateValidationResult attrValResult : attributeCertificateValidationResults) {
                CertInfo ci = this.getCertInfo(attrValResult.getCert());
                attributeCertInfos.add(ci);
            }
            result.setAttributeCertificateInfos(attributeCertInfos);
        }
        PolicyReference policyRef = this.policies.get(sig.getPolicyReference());
        result.setPolicyReference(policyRef);
        if (sig instanceof AdESSignatureValidationResult) {
            AdESSignatureValidationResult ades = (AdESSignatureValidationResult)sig;
            SignatureAttributesType signatureAttributes = ades.getSignatureAttributes();
            List attrList = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            SignReasonType signReason = (SignReasonType)SignatureAttributesUtils.findByNameAndType((String)"signReason", SignReasonType.class, (List)attrList);
            List commitments = SignatureAttributesUtils.findAllByNameAndType((String)"commitmentTypeIndication", CommitmentTypeIndicationType.class, (List)attrList);
            SignerLocationType signerLocation = (SignerLocationType)SignatureAttributesUtils.findByNameAndType((String)"signerLocation", SignerLocationType.class, (List)attrList);
            SigPolicyIdentifierType policyIdentifier = (SigPolicyIdentifierType)SignatureAttributesUtils.findByNameAndType((String)"signaturePolicyIdentifier", SigPolicyIdentifierType.class, (List)attrList);
            result.setSignReason(signReason);
            result.setCommitments(commitments);
            result.setSignerLocation(signerLocation);
            result.setSignaturePolicyIdentifier(policyIdentifier);
        }
        List<PreprocessedTimestampResult> timestampsResults = this.processTimestamps(sig.getSignatureTimestampResults());
        result.setSignatureTimestamps(timestampsResults);
        List<PreprocessedTimestampResult> contentTimestampResults = this.processTimestamps(sig.getSignedDataTimestampResults());
        result.setSignedDataTimestamps(contentTimestampResults);
        result.setClaimedSigningTime(sig.getClaimedSigningTime());
        result.setBestSignatureTime(sig.getBestSignatureTime());
        result.setBestSignatureTimeType(sig.getBestSignatureTimeType());
        PreprocessedQualityInformation sigLevel = this.createSignatureLevel((SignatureValidationResult)sig, sig);
        result.setQualityInformation(sigLevel);
        PreprocessedSignatureValidationResult sigValResult = this.createSignatureValidationResult(sig);
        result.setSignatureValidationResult(sigValResult);
        return result;
    }

    private PreprocessedSignatureResult processSignature(SignatureValidationResult sig) {
        PreprocessedSignatureResult result = new PreprocessedSignatureResult();
        this.transferBaseResults(sig, result);
        List attributeCertificateValidationResults = sig.getAttributeCertificateValidationResults();
        if (attributeCertificateValidationResults != null && !attributeCertificateValidationResults.isEmpty()) {
            ArrayList<CertInfo> attributeCertInfos = new ArrayList<CertInfo>();
            for (AttributeCertificateValidationResult attrValResult : attributeCertificateValidationResults) {
                CertInfo ci = this.getCertInfo(attrValResult.getCert());
                attributeCertInfos.add(ci);
            }
            result.setAttributeCertificateInfos(attributeCertInfos);
        }
        if (sig instanceof AdESSignatureValidationResult) {
            AdESSignatureValidationResult ades = (AdESSignatureValidationResult)sig;
            SignatureAttributesType signatureAttributes = ades.getSignatureAttributes();
            if (signatureAttributes != null) {
                List attrList = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
                SignReasonType signReason = (SignReasonType)SignatureAttributesUtils.findByNameAndType((String)"signReason", SignReasonType.class, (List)attrList);
                List commitments = SignatureAttributesUtils.findAllByNameAndType((String)"commitmentTypeIndication", CommitmentTypeIndicationType.class, (List)attrList);
                SignerLocationType signerLocation = (SignerLocationType)SignatureAttributesUtils.findByNameAndType((String)"signerLocation", SignerLocationType.class, (List)attrList);
                SigPolicyIdentifierType policyIdentifier = (SigPolicyIdentifierType)SignatureAttributesUtils.findByNameAndType((String)"signaturePolicyIdentifier", SigPolicyIdentifierType.class, (List)attrList);
                result.setSignReason(signReason);
                result.setCommitments(commitments);
                result.setSignerLocation(signerLocation);
                result.setSignaturePolicyIdentifier(policyIdentifier);
            }
            List<PreprocessedEvidenceRecordValidationResult> evidenceRecordValidationResult = this.processEvidenceRecords(((AdESSignatureValidationResult)sig).getEvidenceRecordValidationResults());
            result.setEvidenceRecordValidationResults(evidenceRecordValidationResult);
            PreprocessedTimestampChainResult archiveTimestampValidationResult = this.processArchiveTimestampResults(((AdESSignatureValidationResult)sig).getArchiveTimestampValidationResults());
            result.setArchiveTimestampValidationResult(archiveTimestampValidationResult);
        }
        if (sig instanceof ERSValidationResult) {
            List<PreprocessedEvidenceRecordValidationResult> evidenceRecordValidationResult = this.processEvidenceRecords(((ERSValidationResult)sig).getEvidenceRecordValidationResults());
            result.setEvidenceRecordValidationResults(evidenceRecordValidationResult);
        }
        if (sig instanceof CAdESSignatureValidationResult) {
            CAdESSignatureValidationResult cades = (CAdESSignatureValidationResult)sig;
            result.setSignatureType(cades.getSignatureType());
        }
        List<PreprocessedTimestampResult> timestampsResults = this.processTimestamps(sig.getSignatureTimestampResults());
        result.setSignatureTimestamps(timestampsResults);
        List<PreprocessedTimestampResult> contentTimestampResults = this.processTimestamps(sig.getSignedDataTimestampResults());
        result.setSignedDataTimestamps(contentTimestampResults);
        result.setClaimedSigningTime(sig.getClaimedSigningTime());
        result.setBestSignatureTime(sig.getBestSignatureTime());
        result.setBestSignatureTimeType(sig.getBestSignatureTimeType());
        PreprocessedSignatureValidationResult sigValResult = this.createSignatureValidationResult(sig);
        result.setSignatureValidationResult(sigValResult);
        return result;
    }

    private PreprocessedSignatureResult processStandaloneTimestamp(de.governikus.csl.uom.validate.TimestampValidationResult tvr) {
        PreprocessedSignatureResult result = new PreprocessedSignatureResult();
        this.transferBaseResults((SignatureValidationResult)tvr, result);
        PreprocessedQualityInformation qualityInformation = result.getQualityInformation();
        this.addTstQualityAndMsg(qualityInformation, tvr);
        result.setUid(this.createUniqueID("timestamp"));
        result.setClaimedSigningTime(tvr.getGenerationTime());
        result.setBestSignatureTime(tvr.getBestSignatureTime());
        result.setBestSignatureTimeType(tvr.getBestSignatureTimeType());
        PreprocessedTimestampValidationReport result2 = new PreprocessedTimestampValidationReport();
        result2.setGenerationTime(tvr.getGenerationTime());
        result2.setUid(this.createUniqueID("timestamp_result"));
        result2.setOverallResult(tvr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        PreprocessedSignatureIntegrityResult integrityResult = this.processIntegrityResult((SignatureValidationResult)tvr);
        result2.setIntegrityResult(integrityResult);
        result2.setEuQcStatement(tvr.isEuQcStatement());
        PreprocessedCertificateList processCertificates = this.processCertificates(tvr.getSigningCertificateValidationResult());
        result2.setSigningCertificateResult(processCertificates);
        result.setSignatureValidationResult(result2);
        return result;
    }

    private void transferBaseResults(SignatureValidationResult sig, BaseResult<?> result) {
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult issuerCertificateValidationResult;
        X509CertificateImpl cert = null;
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult = sig.getSigningCertificateValidationResult();
        if (signingCertificateValidationResult != null) {
            cert = signingCertificateValidationResult.getCert();
        }
        CertInfo signerInfo = this.getCertInfo(signingCertificateValidationResult, cert);
        result.setSignerInfo(signerInfo);
        if (signingCertificateValidationResult != null && (issuerCertificateValidationResult = signingCertificateValidationResult.getSigningCertificateValidationResult()) != null) {
            CertInfo issuerInfo = this.getCertInfo(issuerCertificateValidationResult, issuerCertificateValidationResult.getCert());
            result.setIssuerInfo(issuerInfo);
        }
        PolicyReference policyRef = this.policies.get(sig.getPolicyReference());
        result.setPolicyReference(policyRef);
        PreprocessedQualityInformation sigLevel = this.createSignatureLevel(sig, signingCertificateValidationResult);
        result.setQualityInformation(sigLevel);
        if (sig instanceof de.governikus.csl.uom.validate.TimestampValidationResult) {
            de.governikus.csl.uom.validate.TimestampValidationResult tvr = (de.governikus.csl.uom.validate.TimestampValidationResult)sig;
            PreprocessedQualityInformation qualityInformation = result.getQualityInformation();
            TimestampQuality timestampQuality = tvr.getTimestampQuality();
            if (qualityInformation != null && timestampQuality != null) {
                qualityInformation.setQualifiedCertificateTypePropertyKey(TimestampQuality.class.getCanonicalName() + "." + timestampQuality.name());
            }
        }
        this.addAlgorithmCatalog(sig.getAlgorithmCatalogInformation());
    }

    private PreprocessedSignatureValidationResult createSignatureValidationResultBase(SignatureValidationResult sig) {
        PreprocessedSignatureValidationResult result = new PreprocessedSignatureValidationResult();
        result.setOverallResult(sig.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        result.setUid(this.createUniqueID("sigResult"));
        PreprocessedSignatureIntegrityResult integrityResult = this.processIntegrityResult(sig);
        result.setIntegrityResult(integrityResult);
        PreprocessedAttributeCertificateResultList attributeCertificates = this.processAttributeCertificates(sig);
        result.setAttributeCertificates(attributeCertificates);
        integrityResult.setContentNames(sig.getContentNames());
        integrityResult.setSignatureClass(sig.getSignatureClass());
        switch (sig.getClass().getSimpleName()) {
            case "CAdESSignatureValidationResult": {
                integrityResult.setSignatureFormatKey("CAdES");
                break;
            }
            case "JAdESSignatureValidationResult": {
                integrityResult.setSignatureFormatKey("JAdES");
                break;
            }
            case "PAdESDocumentValidationResult": 
            case "PAdESRevisionValidationResult": {
                integrityResult.setSignatureFormatKey("PAdES");
                break;
            }
            case "XAdESSignatureValidationResult": {
                integrityResult.setSignatureFormatKey("XAdES");
                break;
            }
        }
        return result;
    }

    private PreprocessedSignatureValidationResult createSignatureValidationResult(SignatureValidationResult sig) {
        PreprocessedSignatureValidationResult result = this.createSignatureValidationResultBase(sig);
        PreprocessedCertificateList processCertificates = this.processCertificates(sig.getSigningCertificateValidationResult());
        result.setSigningCertificateResult(processCertificates);
        return result;
    }

    private PreprocessedSignatureValidationResult createSignatureValidationResult(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult sig) {
        PreprocessedSignatureValidationResult result = this.createSignatureValidationResultBase((SignatureValidationResult)sig);
        PreprocessedCertificateList processCertificates = this.processCertificates(sig);
        result.setSigningCertificateResult(processCertificates);
        return result;
    }

    private PreprocessedAttributeCertificateResultList processAttributeCertificates(SignatureValidationResult sig) {
        List attributeCertificateValidationResults = sig.getAttributeCertificateValidationResults();
        if (attributeCertificateValidationResults == null || attributeCertificateValidationResults.isEmpty()) {
            return null;
        }
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult = sig.getSigningCertificateValidationResult();
        X509CertificateImpl cert = null;
        if (signingCertificateValidationResult != null) {
            cert = signingCertificateValidationResult.getCert();
        }
        String holderSubjectName = this.getSigner(signingCertificateValidationResult, cert);
        String holderIssuerName = this.getIssuer((CertificateValidationResult)signingCertificateValidationResult, (X509CertificateBaseFacade<?>)cert);
        BigInteger holderSerial = null;
        if (cert != null) {
            holderSerial = cert.getSerialNumber();
        }
        ArrayList<PreprocessedCertificateList> attribResults = new ArrayList<PreprocessedCertificateList>();
        for (AttributeCertificateValidationResult attribResult : attributeCertificateValidationResults) {
            PreprocessedCertificateList r = this.processCertificates(attribResult, holderSubjectName, holderIssuerName, holderSerial);
            attribResults.add(r);
        }
        PreprocessedAttributeCertificateResultList result = new PreprocessedAttributeCertificateResultList();
        result.setAttributeCertificateResults(attribResults);
        result.setOverallResult(SignalAggregateUtil.aggregate((List)attributeCertificateValidationResults, (NestedResultCumulationInstruction)NestedResultCumulationInstruction.INCLUDE_MAJOR));
        return result;
    }

    private PreprocessedCertificateList processCertificates(AttributeCertificateValidationResult attribResult, String holderSubjectName, String holderIssuerName, BigInteger holderSerial) {
        PreprocessedCertificateList result = new PreprocessedCertificateList();
        result.setUid(this.createUniqueID("attributeCertList"));
        result.setOverallResult(attribResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        ArrayList<PreprocessedCertificateResult> certList = new ArrayList<PreprocessedCertificateResult>();
        PreprocessedCertificateResult attributeCertificate = this.processAttributeCertificate(attribResult, holderSubjectName, holderIssuerName, holderSerial);
        result.setAttributeCertHolderSubjName(holderSubjectName);
        result.setAttributeCertSerialNumber(attributeCertificate.getSerialNumber());
        certList.add(attributeCertificate);
        for (de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult tmp = attribResult.getSigningCertificateValidationResult(); tmp != null; tmp = tmp.getSigningCertificateValidationResult()) {
            PreprocessedCertificateResult x509 = this.processPublicKeyCertificate(tmp);
            certList.add(x509);
        }
        result.setCertResults(certList);
        ValidityModelDeterminationResult validityModel = attribResult.getValidityModel();
        result.setValidityModel(validityModel);
        return result;
    }

    private PreprocessedCertificateList processCertificates(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult) {
        ForwardedCVSInfo forwardedCSVInfo;
        if (signingCertificateValidationResult == null) {
            return null;
        }
        PreprocessedCertificateList result = new PreprocessedCertificateList();
        result.setUid(this.createUniqueID("certList"));
        result.setOverallResult(signingCertificateValidationResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        ArrayList<PreprocessedCertificateResult> certList = new ArrayList<PreprocessedCertificateResult>();
        for (de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult tmp = signingCertificateValidationResult; tmp != null; tmp = tmp.getSigningCertificateValidationResult()) {
            PreprocessedCertificateResult x509 = this.processPublicKeyCertificate(tmp);
            x509.setCertificateValidationResult(tmp);
            certList.add(x509);
        }
        result.setCertResults(certList);
        this.checkChildsAndOverrideIfApplicable(certList);
        ValidityModelDeterminationResult validityModel = signingCertificateValidationResult.getValidityModel();
        result.setValidityModel(validityModel);
        this.validatorInfo.setCvsURL(signingCertificateValidationResult.getCvsURL());
        this.validatorInfo.setCvsVersion(signingCertificateValidationResult.getCvsVersion());
        if (signingCertificateValidationResult instanceof PublicKeyCertificateValidationResult && (forwardedCSVInfo = ((PublicKeyCertificateValidationResult)signingCertificateValidationResult).getForwardedCVSInfo()) != null) {
            this.validatorInfo.setForwardingValidatorInfo(ValidationReportPreProcessor.createPreprocessValidatorInfo(forwardedCSVInfo));
        }
        return result;
    }

    @NonNull
    private static PreprocessValidatorInfo createPreprocessValidatorInfo(@NonNull ForwardedCVSInfo forwardedCSVInfo) {
        if (forwardedCSVInfo == null) {
            throw new NullPointerException("forwardedCSVInfo is marked non-null but is null");
        }
        PreprocessValidatorInfo preprocessValidatorInfo = new PreprocessValidatorInfo();
        preprocessValidatorInfo.setCvsURL(forwardedCSVInfo.getUrl());
        preprocessValidatorInfo.setCvsVersion(forwardedCSVInfo.getVersion());
        return preprocessValidatorInfo;
    }

    private void checkChildsAndOverrideIfApplicable(List<PreprocessedCertificateResult> certList) {
        if (certList.size() > 1) {
            for (int i = certList.size() - 1; i > 0; --i) {
                CumulatedValidationResult parentOverallWithAll;
                PreprocessedCertificateResult child;
                CumulatedValidationResult childOverallWithAll;
                PreprocessedCertificateResult parent = certList.get(i);
                if (parent.getOverallResult().getMajor().compareTo((Enum)MajorTotalResult.TOTAL_PASSED) <= 0 || !(childOverallWithAll = (child = certList.get(i - 1)).getCertificateValidationResult().getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES)).equals(parentOverallWithAll = parent.getCertificateValidationResult().getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES))) continue;
                BigInteger serialNumber = parent.getCertificate().getSerialNumber();
                PreProcessedRevocationValueResult revocationValueResult = child.getRevocationValueResult();
                if (revocationValueResult != null && revocationValueResult.getRevocationValueValidationResult() != null && this.containsCertAsInvalidIn(serialNumber, revocationValueResult.getRevocationValueValidationResult())) continue;
                child.setOverallResult((CumulatedValidationResult)new CumulatedValidationResultImpl(MajorTotalResult.TOTAL_PASSED, (MinorResult)null));
            }
        }
    }

    private boolean containsCertAsInvalidIn(BigInteger serialNumber, RevocationValueValidationResult revocationValueValidationResult) {
        if (revocationValueValidationResult == null) {
            return false;
        }
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult = revocationValueValidationResult.getSigningCertificateValidationResult();
        if (signingCertificateValidationResult == null) {
            return false;
        }
        if (signingCertificateValidationResult.getCert().getSerialNumber().equals(serialNumber) && signingCertificateValidationResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES).getMajor().compareTo((Enum)MajorTotalResult.TOTAL_PASSED) > 0) {
            return true;
        }
        boolean result = this.containsCertAsInvalidIn(serialNumber, signingCertificateValidationResult.getRevocationValueValidationResult());
        if (result) {
            return result;
        }
        de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult parent = signingCertificateValidationResult.getSigningCertificateValidationResult();
        if (parent != null) {
            if (parent.getCert().getSerialNumber().equals(serialNumber) && parent.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES).getMajor().compareTo((Enum)MajorTotalResult.TOTAL_PASSED) > 0) {
                return true;
            }
            return this.containsCertAsInvalidIn(serialNumber, parent.getRevocationValueValidationResult());
        }
        return false;
    }

    private PreprocessedCertificateResult processCertificate(CertificateValidationResult tmp) {
        PreprocessedCertificateResult result = new PreprocessedCertificateResult();
        result.setUid(this.createUniqueID("certResult"));
        result.setOverallResult(tmp.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        Principal issuerInfos = tmp.getIssuerInfos();
        if (issuerInfos != null) {
            result.setCountry(issuerInfos.getCountry());
        }
        result.setTrustCenterReliability(tmp.getTrustCenterReliability());
        this.transferBaseValidations(result, (SignatureValidationResult)tmp);
        result.setBestSignatureTimeType(tmp.getBestSignatureTimeType());
        result.setValidityCheck(tmp.getValidityCheck());
        ValidationResult revocationStatusCheck = tmp.getRevocationStatusCheck();
        RevocationValueValidationResult revocationValueValidationResult = tmp.getRevocationValueValidationResult();
        if (revocationValueValidationResult != null) {
            revocationStatusCheck = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{revocationStatusCheck, revocationValueValidationResult.getFreshnessCheckResult()});
        }
        result.setRevocationStatusCheck(revocationStatusCheck);
        result.setRevocationDate(tmp.getRevocationDate());
        result.setRevocationReason(tmp.getRevocationReason());
        if (revocationValueValidationResult != null) {
            PreProcessedRevocationValueResult revocationValueResult = this.processRevocationValue(revocationValueValidationResult);
            result.setRevocationValueResult(revocationValueResult);
            if (revocationValueValidationResult.getOcsp() != null) {
                result.setRevocationValueType(RevocationValueType.OCSP);
            } else if (revocationValueValidationResult.getCrl() != null) {
                result.setRevocationValueType(RevocationValueType.CRL);
            }
            result.setRevocationInformationSource(revocationValueValidationResult.getInformationSource());
            result.setRevocationThisUpdate(revocationValueValidationResult.getThisUpdate());
            result.setRevocationNextUpdate(revocationValueValidationResult.getNextUpdate());
            result.setRevocationValueURL(revocationValueValidationResult.getUrl());
        }
        this.addAlgorithmCatalog(tmp.getAlgorithmCatalogInformation());
        result.setRevocationTrustCheckResult(tmp.getRevocationTrustCheckResult());
        return result;
    }

    private PreprocessedCertificateResult processPublicKeyCertificate(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult tmp) {
        PreprocessedCertificateResult result = this.processCertificate((CertificateValidationResult)tmp);
        X509CertificateImpl cert = tmp.getCert();
        result.setCommonName(this.getSigner(tmp, cert));
        result.setTrustedAnchor(tmp.isTrustedAnchor());
        result.setIssuerCommonName(this.getIssuer((CertificateValidationResult)tmp, (X509CertificateBaseFacade<?>)cert));
        result.setCertificate((X509CertificateBaseFacade<?>)cert);
        result.setCertificateDownloadURL(tmp.getDownloadUrl());
        if (cert != null) {
            result.setSerialNumber(cert.getSerialNumber());
        }
        CertInfo certInfo = this.getCertInfo(tmp, cert);
        result.setCertificateDetails(certInfo);
        TLInfo tslInfo = tmp.getTSLInfo();
        if (tslInfo != null) {
            TLInfo tslExtensionInfo = tmp.getTslExtensionInfo();
            PreprocessedTLInfo info = this.addTSLInfo(tslInfo, tslExtensionInfo, tmp.getTlValidityCheck());
            result.setTSLInfo(info);
        } else {
            this.addCheckedTlInfos(tmp);
        }
        TLInfo lotlInfo = tmp.getLotlInfo();
        if (lotlInfo != null) {
            PreprocessedTLInfo l = this.addLotlInfo(lotlInfo);
            result.setLotlInfo(l);
        }
        result.setInformationSource(tmp.getInformationSource());
        result.setAlgorithmCatalogWrapper(this.algorithmCatalogs.get(tmp.getAlgorithmCatalogInformation()));
        return result;
    }

    private void addCheckedTlInfos(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult tmp) {
        List checkedTslInfos = tmp.getCheckedTslInfos();
        List checkedTslExtensionInfos = tmp.getCheckedTslExtensionInfos();
        for (int i = 0; i < checkedTslInfos.size(); ++i) {
            TLInfo tlInfo = (TLInfo)checkedTslInfos.get(i);
            TLInfo tlExtInfo = null;
            if (i < checkedTslExtensionInfos.size()) {
                tlExtInfo = (TLInfo)checkedTslExtensionInfos.get(i);
            }
            this.addTSLInfo(tlInfo, tlExtInfo, null);
        }
    }

    private PreprocessedCertificateResult processAttributeCertificate(AttributeCertificateValidationResult tmp, String holderSubjectName, String holderIssuerName, BigInteger holderSerial) {
        PreprocessedCertificateResult result = this.processCertificate((CertificateValidationResult)tmp);
        X509AttributeCertificateImpl cert = tmp.getCert();
        result.setCommonName(holderSubjectName);
        result.setHolderIssuerName(holderIssuerName);
        result.setIssuerCommonName(this.getIssuer((CertificateValidationResult)tmp, (X509CertificateBaseFacade<?>)cert));
        result.setCertificate((X509CertificateBaseFacade<?>)cert);
        if (cert != null) {
            result.setSerialNumber(cert.getSerialNumber());
        }
        CertInfo certInfo = this.getCertInfo(cert);
        result.setCertificateDetails(certInfo);
        result.setHolderCommonName(holderSubjectName);
        result.setHolderSerialNumber(holderSerial);
        result.setBaseCertificateCheck(tmp.getBaseCertificateCheck());
        result.setAttributeCert(true);
        result.setInformationSource(tmp.getInformationSource());
        return result;
    }

    private PreProcessedRevocationValueResult processRevocationValue(RevocationValueValidationResult revocationValueValidationResult) {
        PreProcessedRevocationValueResult result = new PreProcessedRevocationValueResult();
        result.setRevocationValueValidationResult(revocationValueValidationResult);
        result.setUid(this.createUniqueID("revocation_value"));
        result.setOverallResult(revocationValueValidationResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        PreprocessedSignatureIntegrityResult integrityResult = this.processIntegrityResult((SignatureValidationResult)revocationValueValidationResult);
        result.setIntegrityResult(integrityResult);
        result.setBestSignatureTime(revocationValueValidationResult.getBestSignatureTime());
        result.setBestSignatureTimeType(revocationValueValidationResult.getBestSignatureTimeType());
        PreprocessedCertificateList processCertificates = this.processCertificates(revocationValueValidationResult.getSigningCertificateValidationResult());
        result.setSigningCertificateResult(processCertificates);
        if (revocationValueValidationResult.getInformationSource() == InformationSource.ONLINE) {
            long requestDuration = revocationValueValidationResult.getRequestDuration();
            this.cumulatedRequestDuration += requestDuration;
        }
        if (revocationValueValidationResult.getSigningCertificateValidationResult() != null) {
            CertInfo subjectInfo = this.getCertInfo(revocationValueValidationResult.getSigningCertificateValidationResult(), revocationValueValidationResult.getSigningCertificateValidationResult().getCert());
            result.setSubjectInfo(subjectInfo);
            if (revocationValueValidationResult.getSigningCertificateValidationResult().getSigningCertificateValidationResult() != null) {
                CertInfo issuerInfo = this.getCertInfo(revocationValueValidationResult.getSigningCertificateValidationResult().getSigningCertificateValidationResult(), revocationValueValidationResult.getSigningCertificateValidationResult().getSigningCertificateValidationResult().getCert());
                result.setIssuerInfo(issuerInfo);
            }
        }
        return result;
    }

    private PreprocessedTLInfo addTSLInfo(TLInfo tslInfo, TLInfo tslExtensionInfo, ValidationResult tlValidityCheckResult) {
        for (PreprocessedTLInfo t : this.trustedLists) {
            if (!t.getTlInfo().equals(tslInfo)) continue;
            return t;
        }
        PreprocessedTLInfo info = new PreprocessedTLInfo();
        info.setTlInfo(tslInfo);
        info.setTlExtensionInfo(tslExtensionInfo);
        info.setUid(this.createUniqueID("tslInfo"));
        info.setNr(this.trustedLists.size() + 1);
        info.setTlValidityCheckResult(tlValidityCheckResult);
        this.trustedLists.add(info);
        return info;
    }

    private PreprocessedTLInfo addLotlInfo(TLInfo tslInfo) {
        for (PreprocessedTLInfo t : this.lotls) {
            if (!t.getTlInfo().equals(tslInfo)) continue;
            return t;
        }
        PreprocessedTLInfo info = new PreprocessedTLInfo();
        info.setTlInfo(tslInfo);
        info.setUid(this.createUniqueID("lotlInfo"));
        info.setNr(this.lotls.size() + 1);
        this.lotls.add(info);
        return info;
    }

    private void transferBaseValidations(BaseValidationResult result, SignatureValidationResult sig) {
        ValidationResult signatureAlgorithmValidationResult;
        AlgorithmValidityResult signatureAlgorithmValidityAtClaimedSigningTime;
        AlgorithmValidityResult signatureAlgorithmValidityAtValidationDate;
        ValidationResult signatureAlgorithmValidationResult2;
        ValidationResult sigMathCheck = null;
        if (sig instanceof de.governikus.csl.uom.validate.TimestampValidationResult) {
            de.governikus.csl.uom.validate.TimestampValidationResult tvr = (de.governikus.csl.uom.validate.TimestampValidationResult)sig;
            sigMathCheck = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{sig.getSignatureMathCheck(), tvr.getImprintCheck()});
        } else {
            sigMathCheck = sig.getSignatureMathCheck();
        }
        result.setSignatureMathCheck(sigMathCheck);
        SignatureAlgorithm signatureAlgorithm = sig.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            String signatureAlgorithmName = VelocityHelper.getExtendedDisplayName((Algorithm)signatureAlgorithm, sig.getSignatureAlgorithmParameters());
            result.setSignatureAlgorithmName(signatureAlgorithmName);
        }
        result.setSignatureAlgorithmExpirationDateVal(sig.getSignatureAlgorithmExpirationDateVal());
        result.setSignatureAlgorithmExpirationDateSign(sig.getSignatureAlgorithmExpirationDateSign());
        AlgorithmValidityResult signatureAlgorithmValidityAtBestPOE = sig.getSignatureAlgorithmValidityAtBestPOE();
        if (signatureAlgorithmValidityAtBestPOE != null && (signatureAlgorithmValidationResult2 = signatureAlgorithmValidityAtBestPOE.getSignatureAlgorithmValidationResult()).getMajor() != MajorTotalResult.NOT_VALIDATED) {
            result.setSignatureAlgorithmValidationResultAtBestPOE(signatureAlgorithmValidationResult2);
            result.setBestSignatureTime(sig.getBestSignatureTime());
            result.setSignatureAlgorithmValidationResultAtBestPOEDateType(signatureAlgorithmValidityAtBestPOE.getValidationDateType());
            result.setSignatureAlgorithmValidationResultAtBestPOEDate(signatureAlgorithmValidityAtBestPOE.getValidationDate());
        }
        if ((signatureAlgorithmValidityAtValidationDate = sig.getSignatureAlgorithmValidityAtValidationDate()) != null) {
            Date validationDate;
            ValidationResult signatureAlgorithmValidationResult3 = signatureAlgorithmValidityAtValidationDate.getSignatureAlgorithmValidationResult();
            if (signatureAlgorithmValidationResult3.getMajor() != MajorTotalResult.NOT_VALIDATED) {
                result.setSignatureAlgorithmValidationResultAtValidationDate(signatureAlgorithmValidationResult3);
            }
            if ((validationDate = signatureAlgorithmValidityAtValidationDate.getValidationDate()) != null && signatureAlgorithmValidityAtValidationDate.getValidationDateType().equals((Object)DateType.EXISTENCE)) {
                result.setValidationDate(validationDate);
            }
        }
        if ((signatureAlgorithmValidityAtClaimedSigningTime = sig.getSignatureAlgorithmValidityAtClaimedSigningTime()) != null && (signatureAlgorithmValidationResult = signatureAlgorithmValidityAtClaimedSigningTime.getSignatureAlgorithmValidationResult()).getMajor() != MajorTotalResult.NOT_VALIDATED) {
            result.setSignatureAlgorithmValidationResultAtClaimedSigningTime(signatureAlgorithmValidationResult);
        }
        result.setClaimedSigningTime(sig.getClaimedSigningTime());
        result.setAlgorithmCatalogWrapper(this.algorithmCatalogs.get(sig.getAlgorithmCatalogInformation()));
    }

    private PreprocessedSignatureIntegrityResult processIntegrityResult(SignatureValidationResult sig) {
        PreprocessedSignatureIntegrityResult result = new PreprocessedSignatureIntegrityResult();
        result.setUid(this.createUniqueID("integrity_result"));
        CumulatedValidationResult integrityOverall = null;
        if (sig instanceof TimestampValidationResult) {
            de.governikus.csl.uom.validate.TimestampValidationResult tvr = (de.governikus.csl.uom.validate.TimestampValidationResult)sig;
            integrityOverall = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{sig.getSignatureValidationIntegrityResult(), tvr.getImprintCheck()});
            integrityOverall = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{integrityOverall, tvr.getFormatCheckResult()});
        } else {
            integrityOverall = sig.getSignatureValidationIntegrityResult();
        }
        integrityOverall = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{integrityOverall, sig.getSigningCertificateUsageCheck()});
        if (sig instanceof ERSValidationResult) {
            integrityOverall = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{sig.getSignatureMathCheck(), ((ERSValidationResult)sig).getDigestAlgoNameCompareCheck()});
        }
        result.setOverallResult(integrityOverall);
        this.transferBaseValidations(result, sig);
        if (sig instanceof ERSValidationResult) {
            result.setDigestAlgoNameCompareCheck((ValidationResult)((ERSValidationResult)sig).getDigestAlgoNameCompareCheck());
        }
        result.setFormatCheckResult((ValidationResult)sig.getFormatCheckResult());
        return result;
    }

    private String createUniqueID(String prefix) {
        return prefix + "_" + ++this.nextID;
    }

    private PreprocessedQualityInformation createSignatureLevel(SignatureValidationResult sig, de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult) {
        if (signingCertificateValidationResult != null) {
            boolean tlInfosFound;
            PreprocessedQualityInformation level = new PreprocessedQualityInformation();
            String qualifiedCertificateTypePropertyKey = VelocityHelper.getQualifiedCertificateTypePropertyKey((SignatureValidationResult)signingCertificateValidationResult);
            level.setQualifiedCertificateTypePropertyKey(qualifiedCertificateTypePropertyKey);
            level.setCertificate(signingCertificateValidationResult.getCert());
            level.setQualityResult(signingCertificateValidationResult.getQualityResult());
            switch (sig.getSignedObjectType()) {
                case CRL: 
                case OCSP: 
                case TIMESTAMP: {
                    level.setServiceStatusDeterminationTime(sig.getClaimedSigningTime());
                    break;
                }
                default: {
                    level.setServiceStatusDeterminationTime(signingCertificateValidationResult.getClaimedSigningTime());
                }
            }
            TLInfo tslInfo = signingCertificateValidationResult.getTSLInfo();
            if (tslInfo != null) {
                TLInfo tslExtensionInfo = signingCertificateValidationResult.getTslExtensionInfo();
                PreprocessedTLInfo tlI = this.addTSLInfo(tslInfo, tslExtensionInfo, signingCertificateValidationResult.getTlValidityCheck());
                level.setTSLInfo(tlI);
            }
            level.setQualityInformation(signingCertificateValidationResult.getQualityInformation());
            level.setQualityResult(signingCertificateValidationResult.getQualityResult());
            TSPInfo trustServiceProviderInformation = signingCertificateValidationResult.getTrustServiceProviderInformation();
            ServiceInfo serviceInfo = signingCertificateValidationResult.getServiceInfo();
            de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult tempResult = signingCertificateValidationResult;
            boolean bl = tlInfosFound = trustServiceProviderInformation != null || serviceInfo != null;
            while (!tlInfosFound && (tempResult = tempResult.getSigningCertificateValidationResult()) != null) {
                trustServiceProviderInformation = tempResult.getTrustServiceProviderInformation();
                serviceInfo = tempResult.getServiceInfo();
                tlInfosFound = trustServiceProviderInformation != null || serviceInfo != null;
            }
            level.setIssuerTrustServiceProviderInformation(trustServiceProviderInformation);
            level.setIssuerServiceInfo(serviceInfo);
            return level;
        }
        return null;
    }

    private List<PreprocessedTimestampResult> processTimestamps(List<? extends de.governikus.csl.uom.validate.TimestampValidationResult> signatureTimestampResults) {
        if (signatureTimestampResults == null || signatureTimestampResults.isEmpty()) {
            return null;
        }
        ArrayList<PreprocessedTimestampResult> result = new ArrayList<PreprocessedTimestampResult>();
        for (de.governikus.csl.uom.validate.TimestampValidationResult timestampValidationResult : signatureTimestampResults) {
            PreprocessedTimestampResult ptvr = this.processTimestamp(timestampValidationResult);
            result.add(ptvr);
        }
        return result;
    }

    private PreprocessedTimestampResult processTimestamp(de.governikus.csl.uom.validate.TimestampValidationResult tvr) {
        PreprocessedTimestampResult r = new PreprocessedTimestampResult();
        this.transferBaseResults((SignatureValidationResult)tvr, r);
        PreprocessedQualityInformation qualityInformation = r.getQualityInformation();
        this.addTstQualityAndMsg(qualityInformation, tvr);
        r.setUid(this.createUniqueID("timestamp"));
        r.setGenerationTime(tvr.getGenerationTime());
        PreprocessedTimestampValidationReport result = new PreprocessedTimestampValidationReport();
        result.setGenerationTime(tvr.getGenerationTime());
        result.setUid(this.createUniqueID("timestamp_result"));
        result.setOverallResult(tvr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        PreprocessedSignatureIntegrityResult integrityResult = this.processIntegrityResult((SignatureValidationResult)tvr);
        result.setIntegrityResult(integrityResult);
        result.setEuQcStatement(tvr.isEuQcStatement());
        PreprocessedCertificateList processCertificates = this.processCertificates(tvr.getSigningCertificateValidationResult());
        result.setSigningCertificateResult(processCertificates);
        r.setSignatureValidationResult(result);
        return r;
    }

    private List<PreprocessedEvidenceRecordValidationResult> processEvidenceRecords(List<? extends EvidenceRecordValidationResult> evidenceRecordValidationResult) {
        if (evidenceRecordValidationResult == null || evidenceRecordValidationResult.isEmpty()) {
            return null;
        }
        ArrayList<PreprocessedEvidenceRecordValidationResult> result = new ArrayList<PreprocessedEvidenceRecordValidationResult>();
        this.processEvidenceRecords(result, evidenceRecordValidationResult);
        if (this.multiplyLtaAndErsWhenPresent) {
            this.processEvidenceRecords(result, evidenceRecordValidationResult);
        }
        return result;
    }

    private void processEvidenceRecords(List<PreprocessedEvidenceRecordValidationResult> result, List<? extends EvidenceRecordValidationResult> evidenceRecordValidationResult) {
        for (EvidenceRecordValidationResult evidenceRecordValidationResult2 : evidenceRecordValidationResult) {
            ++this.nextTSID;
            PreprocessedEvidenceRecordValidationResult pervr = this.processEvidenceRecord(this.nextTSID, evidenceRecordValidationResult2);
            pervr.setId(String.valueOf(this.nextTSID));
            result.add(pervr);
        }
    }

    private PreprocessedEvidenceRecordValidationResult processEvidenceRecord(int erId, EvidenceRecordValidationResult ervr) {
        ArrayList<PreprocessedTimestampChainResult> tscrList = new ArrayList<PreprocessedTimestampChainResult>();
        PreprocessedEvidenceRecordValidationResult er = new PreprocessedEvidenceRecordValidationResult();
        er.setTimestampChainResultList(tscrList);
        er.setOverallResult(ervr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        int id = 0;
        id = this.processEvidenceRecord(tscrList, erId, id, ervr);
        if (this.multiplyLtaAndErsWhenPresent) {
            this.processEvidenceRecord(tscrList, erId, id, ervr);
        }
        Collections.reverse(tscrList);
        return er;
    }

    private int processEvidenceRecord(List<PreprocessedTimestampChainResult> tscrList, int erId, int id, EvidenceRecordValidationResult ervr) {
        for (ERArchiveTimestampChainValidationResult erArchiveChainResult : ervr.getTimestampChainResponses()) {
            PreprocessedTimestampChainResult tscr = this.processERArchiveTimestampChainValidationResult(erId, ++id, erArchiveChainResult);
            tscrList.add(tscr);
        }
        return id;
    }

    private PreprocessedTimestampChainResult processERArchiveTimestampChainValidationResult(int erId, int chId, ERArchiveTimestampChainValidationResult erArchiveChainResult) {
        ArrayList<PreprocessedArchiveTimestampResult> erArchiveResultList = new ArrayList<PreprocessedArchiveTimestampResult>();
        PreprocessedERSBackedTimestampChainResult tsChainResult = new PreprocessedERSBackedTimestampChainResult();
        tsChainResult.setTimestampResultList(erArchiveResultList);
        tsChainResult.setOverallResult(erArchiveChainResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES));
        tsChainResult.setId(erId + "." + chId);
        int id = 0;
        id = this.processERArchiveTimestampChainValidationResult(tsChainResult, erArchiveResultList, id, erId, chId, erArchiveChainResult);
        if (this.multiplyLtaAndErsWhenPresent) {
            this.processERArchiveTimestampChainValidationResult(tsChainResult, erArchiveResultList, id, erId, chId, erArchiveChainResult);
        }
        Collections.reverse(erArchiveResultList);
        return tsChainResult;
    }

    private int processERArchiveTimestampChainValidationResult(PreprocessedERSBackedTimestampChainResult tsChainResult, List<PreprocessedArchiveTimestampResult> erArchiveResultList, int id, int erId, int chId, ERArchiveTimestampChainValidationResult erArchiveChainResult) {
        for (ERArchiveTimestampValidationResult erArchiveResult : erArchiveChainResult.getTimestampResponses()) {
            PreprocessedArchiveTimestampResult timestampResult = this.processArchiveTimestampResult(erArchiveResult);
            timestampResult.setId(erId + "." + chId + "." + ++id);
            erArchiveResultList.add(timestampResult);
            tsChainResult.setValidationTime(erArchiveResult.getValidationDate());
            ERHashTreeValidationResult hashTreeValidationResult = erArchiveResult.getHashTreeValidationResult();
            if (hashTreeValidationResult == null) continue;
            this.addAlgorithmCatalog(hashTreeValidationResult.getAlgorithmCatalogInformation());
            tsChainResult.setAlgorithmCatalogWrapper(this.algorithmCatalogs.get(hashTreeValidationResult.getAlgorithmCatalogInformation()));
            DigestAlgorithmValidityInformation daInfo = hashTreeValidationResult.getDigestAlgorithmValidationResult();
            if (daInfo == null) continue;
            tsChainResult.setDigestAlgorithmName(VelocityHelper.getDisplayName((Algorithm)daInfo.getDigestAlgorithm(), null));
            tsChainResult.setDigestAlgorithmExpirationDate(daInfo.getAlgorithmExpirationDate());
            tsChainResult.setDigestAlgorithmValidationResult(daInfo.getValidationResult());
        }
        return id;
    }

    private PreprocessedArchiveTimestampResult processArchiveTimestampResult(ERArchiveTimestampValidationResult erArchiveResult) {
        PreprocessedArchiveTimestampResult timestampResult = new PreprocessedArchiveTimestampResult();
        timestampResult.setValidationTime(erArchiveResult.getValidationDate());
        timestampResult.setTimestampResult(this.processTimestamp((de.governikus.csl.uom.validate.TimestampValidationResult)erArchiveResult.getTimestampTokenValidationResult()));
        timestampResult.setHashTreeValidationResult(erArchiveResult.getHashTreeValidationResult());
        timestampResult.setOverallResult(erArchiveResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR));
        return timestampResult;
    }

    private PreprocessedTimestampChainResult processArchiveTimestampResults(List<ArchiveTimestampValidationResult> archiveTimestampResults) {
        if (archiveTimestampResults == null || archiveTimestampResults.isEmpty()) {
            return null;
        }
        ArrayList<PreprocessedArchiveTimestampResult> tsArchiveResultList = new ArrayList<PreprocessedArchiveTimestampResult>();
        PreprocessedTimestampChainResult tsChainResult = new PreprocessedTimestampChainResult();
        CumulatedValidationResult overallResult = null;
        ++this.nextTSID;
        tsChainResult.setId(String.valueOf(this.nextTSID));
        tsChainResult.setTimestampResultList(tsArchiveResultList);
        int id = 0;
        ProcessArchiveTimestampResultsResult tmp = this.processArchiveTimestampResults(tsArchiveResultList, id, archiveTimestampResults, overallResult);
        if (this.multiplyLtaAndErsWhenPresent) {
            this.processArchiveTimestampResults(tsArchiveResultList, tmp.id, archiveTimestampResults, overallResult);
        }
        tsChainResult.setOverallResult(tmp.overallResult);
        return tsChainResult;
    }

    private ProcessArchiveTimestampResultsResult processArchiveTimestampResults(List<PreprocessedArchiveTimestampResult> tsArchiveResultList, int id, List<ArchiveTimestampValidationResult> archiveTimestampResults, CumulatedValidationResult overallResult) {
        for (ArchiveTimestampValidationResult tsResult : archiveTimestampResults) {
            PreprocessedArchiveTimestampResult timestampResult = new PreprocessedArchiveTimestampResult();
            timestampResult.setId(String.valueOf(this.nextTSID) + "." + (archiveTimestampResults.size() - id++));
            timestampResult.setTimestampResult(this.processTimestamp((de.governikus.csl.uom.validate.TimestampValidationResult)tsResult));
            timestampResult.setOverallResult(null);
            timestampResult.setValidationTime(null);
            timestampResult.setUsageHint(tsResult.getUsageHint());
            CumulatedValidationResult cvr = tsResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES);
            overallResult = SignalAggregateUtil.aggregate((ValidationResult[])new ValidationResult[]{overallResult, cvr});
            tsArchiveResultList.add(timestampResult);
        }
        return new ProcessArchiveTimestampResultsResult(id, overallResult);
    }

    private CertInfo getCertInfo(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult, X509CertificateImpl cert) {
        CertInfo info = new CertInfo();
        info.setCommonName(this.getSigner(signingCertificateValidationResult, cert));
        if (cert != null) {
            info.setCertificateDetails(VelocityHelper.getCertificateDetails(this.rbCert, cert, this.shortCertInfo));
        }
        return info;
    }

    protected CertInfo getCertInfo(X509AttributeCertificateImpl cert) {
        CertInfo info = new CertInfo();
        if (cert != null) {
            info.setCommonName(cert.getSerialNumber().toString());
            List<Flattable.Pair> certificateDetails = VelocityHelper.getCertificateDetails(this.rbCert, cert, this.shortCertInfo);
            this.removeClosingAttributesTable(certificateDetails);
            info.setCertificateDetails(certificateDetails);
        }
        return info;
    }

    protected void removeClosingAttributesTable(List<Flattable.Pair> certificateDetails) {
        if (certificateDetails == null) {
            return;
        }
        boolean prevWasAttributeHeading = false;
        ListIterator<Flattable.Pair> certDetailsIt = certificateDetails.listIterator();
        while (certDetailsIt.hasNext()) {
            Flattable.Pair pair = certDetailsIt.next();
            if (this.rbCert.getString("attributes").equals(pair.label) && pair.value == null) {
                prevWasAttributeHeading = true;
                continue;
            }
            if (!prevWasAttributeHeading) continue;
            if (pair.label != null || pair.value != null) break;
            certDetailsIt.remove();
            break;
        }
    }

    private String getSigner(de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult signingCertificateValidationResult, X509CertificateImpl signingCertificate) {
        String commonName;
        Principal subjectInfos;
        if (signingCertificateValidationResult != null && (subjectInfos = signingCertificateValidationResult.getSubjectInfos()) != null && (commonName = subjectInfos.getCommonName()) != null) {
            return commonName;
        }
        if (signingCertificate != null) {
            return VelocityHelper.getCertificateCN(signingCertificate.getSubjectX500Principal());
        }
        return null;
    }

    private String getIssuer(CertificateValidationResult signingCertificateValidationResult, X509CertificateBaseFacade<?> signingCertificate) {
        String commonName;
        Principal subjectInfos;
        if (signingCertificateValidationResult != null && (subjectInfos = signingCertificateValidationResult.getIssuerInfos()) != null && (commonName = subjectInfos.getCommonName()) != null) {
            return commonName;
        }
        if (signingCertificate != null) {
            return VelocityHelper.getCertificateCN(signingCertificate.getIssuerX500Principal());
        }
        return null;
    }

    private void addAlgorithmCatalog(AlgorithmCatalogMetaInformation catalogInfo) {
        if (catalogInfo != null && !this.algorithmCatalogs.keySet().contains(catalogInfo)) {
            this.algorithmCatalogs.put(catalogInfo, new AlgorithmCatalogWrapper(this.createUniqueID("algoCat"), catalogInfo));
        }
    }

    private void addTstQualityAndMsg(PreprocessedQualityInformation qualityInformation, de.governikus.csl.uom.validate.TimestampValidationResult tvr) {
        if (tvr.getTimestampQuality() != null) {
            qualityInformation.setQualifiedCertificateTypePropertyKey(TimestampQuality.class.getCanonicalName() + "." + tvr.getTimestampQuality().name());
            CertificateQualityResult certResult = new CertificateQualityResult();
            certResult.getMessages().add((ValidationMessageCode)tvr.getTimestampQualificationMsgCode());
            de.governikus.csl.validate.svp.QualityResult qualityResult = new de.governikus.csl.validate.svp.QualityResult();
            qualityResult.setCertificateQualityResult(certResult);
            qualityInformation.setQualityResult((QualityResult)qualityResult);
        }
    }

    private static class ProcessArchiveTimestampResultsResult {
        int id;
        CumulatedValidationResult overallResult;

        public ProcessArchiveTimestampResultsResult(int id, CumulatedValidationResult overallResult) {
            this.id = id;
            this.overallResult = overallResult;
        }
    }
}

