/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnprintableCharSkippingFilterWriter
extends FilterWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnprintableCharSkippingFilterWriter.class);

    protected UnprintableCharSkippingFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isPrintable((char)c)) {
            super.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null || cbuf.length == 0 || len == 0) {
            return;
        }
        int cntPrintable = 0;
        char[] tmpChar = new char[len];
        for (int cnt = 0; cnt < len; ++cnt) {
            char c = cbuf[off + cnt];
            if (!this.isPrintable(c)) continue;
            tmpChar[cntPrintable++] = c;
        }
        super.write(tmpChar, 0, cntPrintable);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str == null || str.isEmpty() || len == 0) {
            return;
        }
        int cntPrintable = 0;
        char[] tmpChar = new char[len];
        for (int cnt = 0; cnt < len; ++cnt) {
            char c = str.charAt(off + cnt);
            if (!this.isPrintable(c)) continue;
            tmpChar[cntPrintable++] = c;
        }
        super.write(tmpChar, 0, cntPrintable);
    }

    private boolean isPrintable(char c) {
        boolean isUnprintable;
        boolean bl = isUnprintable = c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\ufffe' && c <= '\uffff';
        if (isUnprintable && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Filtered: 0x", (Object)Integer.toHexString(c));
        }
        return !isUnprintable;
    }
}

