/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import de.governikus.csl.inspect.common.SummaryRow;
import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SummaryRowExtractor
extends ObjectValidationResultVisitor<ObjectValidationResult> {
    private List<SummaryRow> rows = new ArrayList<SummaryRow>();
    private int ctr = 0;
    private Stack<IncludedFileSignatureCounter> stack = new Stack();

    public void startVisitingObjectValidationResult(ObjectValidationResult objectValidationResult) {
        List signatureValidationResults = objectValidationResult.getSignatureValidationResults();
        if (signatureValidationResults != null && !signatureValidationResults.isEmpty()) {
            this.addToResult(objectValidationResult);
            if (!this.stack.isEmpty()) {
                IncludedFileSignatureCounter includedFileSignatureCounter = this.stack.peek();
                includedFileSignatureCounter.ctr = includedFileSignatureCounter.ctr + signatureValidationResults.size();
            }
        }
    }

    public void startVisitingIncludedFileValidationResults(ObjectValidationResult objectValidationResult) {
        this.stack.add(new IncludedFileSignatureCounter());
    }

    public void stopVisitingIncludedFileValidationResults(ObjectValidationResult objectValidationResult) {
        IncludedFileSignatureCounter pop = this.stack.pop();
        if (pop.ctr == 0) {
            this.addToResult(objectValidationResult);
        }
    }

    private void addToResult(ObjectValidationResult objectValidationResult) {
        List signatureValidationResults = objectValidationResult.getSignatureValidationResults();
        if (signatureValidationResults != null && !signatureValidationResults.isEmpty()) {
            for (SignatureValidationResult svr : signatureValidationResults) {
                SummaryRow sr = new SummaryRow();
                sr.setDocument(objectValidationResult);
                sr.setNr(++this.ctr);
                sr.setSignatureValidationResult(svr);
                this.rows.add(sr);
            }
        } else {
            SummaryRow sr = new SummaryRow();
            sr.setDocument(objectValidationResult);
            sr.setNr(++this.ctr);
            this.rows.add(sr);
        }
    }

    public List<SummaryRow> getRows() {
        return this.rows;
    }

    public void setRows(List<SummaryRow> rows) {
        this.rows = rows;
    }

    private class IncludedFileSignatureCounter {
        private int ctr = 0;

        private IncludedFileSignatureCounter() {
        }
    }
}

