/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.common;

import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import java.util.HashMap;
import java.util.Map;

public class ACMetaInformationCollectionResultVisitor
extends ObjectValidationResultVisitor<ObjectValidationResult> {
    private Map<String, AlgorithmCatalogMetaInformation> algoCatInformation = new HashMap<String, AlgorithmCatalogMetaInformation>();

    public void startVisitingCertificateValidationResult(PublicKeyCertificateValidationResult s) {
        this.process((SignatureValidationResult)s);
    }

    public void startVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        this.process((SignatureValidationResult)revocationValueValidationResult);
    }

    public void startVisitingSignatureTimestampValidationResult(TimestampValidationResult tsr) {
        this.process((SignatureValidationResult)tsr);
    }

    public void startVisitingSignatureValidationResult(SignatureValidationResult signatureValidationResult) {
        this.process(signatureValidationResult);
    }

    public void startVisitingSignedDataTimestampValidationResult(TimestampValidationResult tsr) {
        this.process((SignatureValidationResult)tsr);
    }

    private void process(SignatureValidationResult s) {
        AlgorithmCatalogMetaInformation algorithmCatalogInformation = s.getAlgorithmCatalogInformation();
        if (algorithmCatalogInformation != null) {
            this.algoCatInformation.put(algorithmCatalogInformation.getPublisherURL(), algorithmCatalogInformation);
        }
    }

    public Map<String, AlgorithmCatalogMetaInformation> getAlgoCatInformation() {
        return this.algoCatInformation;
    }
}

