/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.raw.sign;

import de.governikus.csl.raw.sign.SignedDocument;
import de.governikus.csl.sign.doc.AbstractDigestDocument;
import de.governikus.csl.sign.doc.DigestDocument;
import de.governikus.csl.uom.jcebase.CertificatePublicKeyFacade;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class SignedDocumentImpl
extends AbstractDigestDocument
implements SignedDocument {
    public static final String RAW_SIGNED_ID_NAME_PREFIX = "RAWSigned-";
    private final String signatureAlgorithmURI;
    private final byte[] signatureValue;
    private final PublicKey signerPublicKey;
    private final List<Certificate> signerCertificateChain;
    private final Certificate signerCertificate;

    public SignedDocumentImpl(String signatureAlgorithmURI, byte[] signatureValue, PublicKey signerPublicKey, List<Certificate> signerCertificateChain) {
        this(signatureAlgorithmURI, signatureValue, signerPublicKey, signerCertificateChain, null, null);
    }

    public SignedDocumentImpl(String signatureAlgorithmURI, byte[] signatureValue, PublicKey signerPublicKey, List<Certificate> signerCertificateChain, DigestDocument digestDocument) throws NullPointerException, IllegalArgumentException {
        this(signatureAlgorithmURI, signatureValue, signerPublicKey, signerCertificateChain, digestDocument != null ? digestDocument.getDigestAlgorithmURI() : null, digestDocument != null ? digestDocument.getDigestValue() : null);
    }

    public SignedDocumentImpl(String signatureAlgorithmURI, byte[] signatureValue, PublicKey signerPublicKey, List<Certificate> signerCertificateChain, String digestAlgorithmURI, byte[] digestValue) throws NullPointerException, IllegalArgumentException {
        super(RAW_SIGNED_ID_NAME_PREFIX + UUID.randomUUID().toString(), digestAlgorithmURI, digestValue);
        this.signatureValue = Objects.requireNonNull(signatureValue, "signature value can not be null");
        if (signatureValue.length == 0) {
            throw new IllegalArgumentException();
        }
        this.signatureAlgorithmURI = Objects.requireNonNull(signatureAlgorithmURI, "URI of signature algorithm can not be null");
        if (signatureAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("URI of signature algorithm can not be an empty String");
        }
        List<Certificate> tmp = null;
        if (signerCertificateChain != null && !signerCertificateChain.isEmpty()) {
            tmp = new ArrayList<Certificate>();
            tmp.addAll(signerCertificateChain);
        } else if (signerPublicKey instanceof CertificatePublicKeyFacade) {
            tmp = new ArrayList();
            CertificatePublicKeyFacade cpkf = (CertificatePublicKeyFacade)signerPublicKey;
            tmp = cpkf.getCertificateChain();
        }
        this.signerCertificate = tmp == null || tmp.isEmpty() ? null : (Certificate)tmp.get(0);
        this.signerCertificateChain = tmp == null ? null : Collections.unmodifiableList(tmp);
        PublicKey tmpKey = signerPublicKey;
        if ((signerPublicKey == null || signerPublicKey instanceof CertificatePublicKeyFacade) && this.signerCertificate != null) {
            tmpKey = this.signerCertificate.getPublicKey();
        }
        this.signerPublicKey = tmpKey;
    }

    @Override
    public boolean isDigestValueAvailable() {
        return this.digestValue != null && this.digestValue.length > 0;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.signatureValue);
    }

    @Override
    public String getSignatureAlgorithmURI() {
        return this.signatureAlgorithmURI;
    }

    @Override
    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    @Override
    public PublicKey getKey() {
        return this.signerPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.signerCertificate;
    }

    @Override
    public List<Certificate> getCertificateChain() {
        return this.signerCertificateChain;
    }
}

