/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.raw.sign;

import de.governikus.csl.raw.sign.RAWSignPlugin;
import de.governikus.csl.sign.doc.impl.DigestDocumentImpl;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.core.SignatureRequest;
import de.governikus.csl.uom.core.impl.DataToBeSignedImpl;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoBuilder;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;

public class RAWSignRequestBuilder {
    String digestAlgorithmURI;
    byte[] digestValue;
    Document document;
    PrivateKeyResourceReferenceParameter privateKey;
    String signatureAlgorithmURI;

    public SignRequest build() throws IllegalStateException {
        Document doc = this.createDocument();
        return new SignatureRequest(this.createSignOptionsBuilder().addSignerInfo(this.createSignerInfoBuilder().build()).build(), DataToBeSignedImpl.getSingletonList((Document[])new Document[]{doc}));
    }

    private String checkAlgorithmNotNull(String algorithm, String algorithmType) throws IllegalArgumentException {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException(algorithmType + " algorithm is required, null or empty String are invalid");
        }
        return algorithm;
    }

    private Document createDocument() throws IllegalStateException {
        if (this.digestAlgorithmURI == null) {
            throw new IllegalStateException("required URI of digest algorithm for signing not configured yet");
        }
        if (this.document == null && this.digestValue == null) {
            throw new IllegalStateException("required digest value or document not configured yet");
        }
        if (this.document == null) {
            return new DigestDocumentImpl(UUID.randomUUID().toString(), this.digestAlgorithmURI, this.digestValue);
        }
        return this.document;
    }

    private SignerInfoBuilder createSignerInfoBuilder() throws IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("required private key for signing not configured yet");
        }
        if (this.signatureAlgorithmURI == null) {
            throw new IllegalStateException("required URI of signature algorithm for signing not configured yet");
        }
        if (this.privateKey instanceof PrivateKey) {
            String keyAlgorithm = ((PrivateKey)this.privateKey).getAlgorithm();
            if (!this.signatureAlgorithmURI.toUpperCase(Locale.getDefault()).contains(keyAlgorithm.toUpperCase(Locale.getDefault()))) {
                throw new IllegalStateException("misconfiguration: algorithm of key for signing does match to signature algorithm - reconfigure: '" + keyAlgorithm + "' must be part of '" + this.signatureAlgorithmURI + "'");
            }
        }
        if (this.digestAlgorithmURI == null) {
            throw new IllegalStateException("required URI of digest algorithm for signing not configured yet");
        }
        return new SignerInfoBuilder().setSignatureAlgorithmURI(this.signatureAlgorithmURI).setDigestAlgorithmURI(this.digestAlgorithmURI).setKey(this.privateKey);
    }

    private SignOptionsBuilder createSignOptionsBuilder() throws IllegalStateException {
        return new SignOptionsBuilder().setPluginID(Plugin.PluginID.SIGN_RAW.toString()).setSignatureType(SignatureType.DETACHED).setPolicy(RAWSignPlugin.POLICY).setInputDocumentFormatClasses(Collections.singleton(Document.class));
    }

    public RAWSignRequestBuilder setDigestAlgorithmURI(String digestAlgorithmURI) throws IllegalArgumentException {
        this.digestAlgorithmURI = this.checkAlgorithmNotNull(digestAlgorithmURI, "digest");
        return this;
    }

    public RAWSignRequestBuilder setDigestValue(byte[] digestValue) throws IllegalArgumentException, IllegalStateException {
        if (this.document != null) {
            throw new IllegalStateException("document is set, digest value can not be set in this state");
        }
        if (this.digestAlgorithmURI == null) {
            throw new IllegalStateException("URI of digest algorithm must be set before setting digest value to check length");
        }
        if (digestValue == null || digestValue.length == 0) {
            throw new IllegalArgumentException("digest value required, null or empty array are invalid");
        }
        this.digestValue = new byte[digestValue.length];
        System.arraycopy(digestValue, 0, this.digestValue, 0, digestValue.length);
        return this;
    }

    public RAWSignRequestBuilder setDocument(Document document) throws IllegalStateException, IllegalArgumentException {
        if (this.digestValue != null) {
            throw new IllegalStateException("digest value is set, document value can not be set in this state");
        }
        if (document == null) {
            throw new IllegalArgumentException("document is required, null is invalid");
        }
        this.document = document;
        return this;
    }

    public RAWSignRequestBuilder setPrivateKey(PrivateKeyResourceReferenceParameter privateKey) throws IllegalArgumentException {
        if (privateKey == null) {
            throw new IllegalArgumentException("signing key is required as reference or resource");
        }
        this.privateKey = privateKey;
        return this;
    }

    public RAWSignRequestBuilder setSignatureAlgorithmURI(String signatureAlgorithmURI) throws IllegalArgumentException {
        this.signatureAlgorithmURI = this.checkAlgorithmNotNull(signatureAlgorithmURI, "signature");
        return this;
    }
}

