/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.raw.sign;

import de.governikus.csl.raw.sign.RAWSigningContext;
import de.governikus.csl.raw.sign.SignedDocument;
import de.governikus.csl.raw.sign.SignedDocumentImpl;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.doc.impl.DigestDocumentImpl;
import de.governikus.csl.sign.impl.AbstractSignPlugin;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.util.Environment;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginType(id=Plugin.PluginID.SIGN_RAW, type=SignPlugin.class)
public class RAWSignPlugin
extends AbstractSignPlugin {
    public static final SignPolicy POLICY = new SignPolicy(){

        public String getId() {
            return "0.1.2.3";
        }

        public String getName() {
            return "RP";
        }

        public PolicyInformation getPolicyInformation() {
            return null;
        }
    };
    public static final List<Class<? extends Document>> DOCUMENT_OUTPUT_CLASSES = Collections.unmodifiableList(Arrays.asList(SignedDocument.class, SignedDocumentImpl.class));
    private static final Logger LOG = LoggerFactory.getLogger(RAWSignPlugin.class);

    public RAWSignPlugin() throws CSLSignatureException {
        super(DOCUMENT_OUTPUT_CLASSES);
    }

    private RAWSigningContext createContext(SignRequest signRequest) throws CSLSignatureException {
        RAWSigningContext context = new RAWSigningContext(signRequest);
        SignOptions signOptions = RAWSignPlugin.checkSignOptions(context);
        context.signerInfo = RAWSignPlugin.checkSignerInfo(signOptions);
        context.policy = RAWSignPlugin.checkPolicy(context, signOptions);
        context.privateKeyResource = RAWSignPlugin.checkKey(context);
        context.dataToBeSigned = RAWSignPlugin.checkDataToBeSigned(signRequest);
        context.document = RAWSignPlugin.checkDocument(context);
        context.privateKeyResource = (PrivateKeyResource)context.signerInfo.getKey();
        context.signerCert = (X509Certificate)context.privateKeyResource.getCertificate().certificate();
        context.signerCertChain = context.privateKeyResource.getCertificateChain().certificates();
        context.algoIdSignature = context.signerInfo.getSignatureAlgorithmURI();
        RAWSignPlugin.checkKeySignatureAlgorithm(context);
        context.algoIdDigest = context.signerInfo.getDigestAlgorithmURI();
        return context;
    }

    private static void checkKeySignatureAlgorithm(RAWSigningContext context) throws CSLSignatureException {
        String keyAlgorithm = context.privateKeyResource.getAlgorithm();
        if (!context.algoIdSignature.toUpperCase(Locale.getDefault()).contains(keyAlgorithm.toUpperCase(Locale.getDefault()))) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "misconfiguration: algorithm of key for signing does match to signature algorithm - reconfigure: '" + keyAlgorithm + "' must be part of '" + context.algoIdSignature + "'");
        }
    }

    private static Document checkDocument(RAWSigningContext context) throws CSLSignatureException {
        List documents = context.dataToBeSigned.getDocuments();
        if (documents == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "documents list ist required, but is null");
        }
        if (documents.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "not empty documents list is required, but is empty");
        }
        if (documents.size() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one document is supported, but there are " + documents.size() + " used");
        }
        Document document = (Document)documents.get(0);
        if (document == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "document entry is required, but is null");
        }
        return document;
    }

    private static DataToBeSigned checkDataToBeSigned(SignRequest signRequest) throws CSLSignatureException {
        List datasToBeSigned = signRequest.getDataToBeSigned();
        if (datasToBeSigned == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "data to be signed list is required, but is null");
        }
        if (datasToBeSigned.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "non empty data to be signed list is required, but is empty");
        }
        if (datasToBeSigned.size() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one data to be signed is supported currently");
        }
        DataToBeSigned dataToBeSigned = (DataToBeSigned)datasToBeSigned.get(0);
        if (dataToBeSigned == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "data to be signed entry is required, but is null");
        }
        return dataToBeSigned;
    }

    private static SignPolicy checkPolicy(RAWSigningContext context, SignOptions signOptions) throws CSLSignatureException {
        SignPolicy policy = (SignPolicy)signOptions.getPolicy();
        if (POLICY != policy) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only RAW sign policy is supported: " + POLICY + ", not supported: " + context.policy);
        }
        return policy;
    }

    private static PrivateKeyResource checkKey(RAWSigningContext context) throws CSLSignatureException {
        PrivateKeyResourceReferenceParameter key = context.signerInfo.getKey();
        if (key == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "null key not usable for signing");
        }
        if (!PrivateKeyResource.class.isInstance(key)) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "not supported key: " + PrivateKeyResource.class + " is required, used: " + key.getClass());
        }
        return (PrivateKeyResource)PrivateKeyResource.class.cast(key);
    }

    private static SignerInfo checkSignerInfo(SignOptions signOptions) throws CSLSignatureException {
        SignerInfo result = (SignerInfo)signOptions.getSignerInfos().iterator().next();
        if (result == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "signer info must be not null");
        }
        return result;
    }

    private static SignOptions checkSignOptions(RAWSigningContext context) throws CSLSignatureException {
        SignOptions signOptions = context.getSignOptions();
        if (signOptions == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "sign options must be not null");
        }
        if (signOptions.getSignerInfos().isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "at least one signer is required for signing");
        }
        if (signOptions.getSignerInfos().size() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "not more than one signer is supported currently");
        }
        return signOptions;
    }

    /*
     * Exception decompiling
     */
    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Signature createInitializedSignature(RAWSigningContext context) throws CoreException {
        Signature signature = null;
        try {
            signature = RAWSignPlugin.getCPPSignatureInstance(context);
            signature.initSign((PrivateKey)context.privateKeyResource);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CoreException) {
                cause = ((CoreException)cause).getCause();
            }
            if (cause instanceof NoSuchAlgorithmException) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "algorithm not supported by CSL provider: " + e.getMessage(), (Throwable)e);
            }
            if (cause instanceof NoSuchProviderException) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "CSL provider not registered unfortunately: " + e.getMessage(), (Throwable)e);
            }
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "key is invalid: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "algorithm not supported by CSL provider: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "CSL provider not registered unfortunately: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare signing at creating signature instance with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        return signature;
    }

    private static Signature getCPPSignatureInstance(RAWSigningContext context) throws NoSuchAlgorithmException, NoSuchProviderException, CoreException {
        String algoIdSignature = context.algoIdSignature;
        String algorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(algoIdSignature);
        if (algorithm == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "mapping for algorithm seems to be incomplete: " + algoIdSignature);
        }
        if (context.document instanceof DigestDocumentImpl) {
            algorithm = algorithm.replace("with", "hashedWith");
        }
        LOG.debug("CSL-algorithm:\n {} -> {}", (Object)algoIdSignature, (Object)algorithm);
        return Signature.getInstance(algorithm, "CPP");
    }
}

