/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.system;

import de.governikus.csc.system.AbstractMBeanConnector;
import de.governikus.csc.system.ConfigurableAutomatedStartBean;
import de.governikus.csl.uom.LogHelper;
import java.io.IOException;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatMBeanConnector<T extends ConfigurableAutomatedStartBean>
extends AbstractMBeanConnector<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatMBeanConnector.class);
    protected JMXConnector jmxConnector;
    private String tomcatServiceURL;
    private String username;
    private String password;

    public TomcatMBeanConnector(String mBeanName, Class<T> clazz) {
        this(mBeanName, "service:jmx:rmi:///jndi/rmi://localhost:9999/jmxrmi", clazz);
    }

    public TomcatMBeanConnector(String mBeanName, String tomcatServiceURL, Class<T> clazz) {
        super(mBeanName, clazz);
        this.tomcatServiceURL = tomcatServiceURL;
    }

    public TomcatMBeanConnector(String mBeanName, String tomcatServiceURL, String username, String password, Class<T> clazz) {
        super(mBeanName, clazz);
        this.tomcatServiceURL = tomcatServiceURL;
        this.username = username;
        this.password = password;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            LogHelper.logException(null, (Logger)LOGGER, (Throwable)e);
        }
    }

    @Override
    public void connect() throws JMException, IOException {
        JMXServiceURL url = new JMXServiceURL(this.tomcatServiceURL);
        JMXConnector jmxConnector = null;
        if (this.username == null) {
            jmxConnector = JMXConnectorFactory.connect(url);
        } else {
            HashMap<String, Object> envMap = new HashMap<String, Object>();
            envMap.put("jmx.remote.credentials", new String[]{this.username, this.password});
            envMap.put("java.naming.security.principal", this.username);
            envMap.put("java.naming.security.credentials", this.password);
            jmxConnector = JMXConnectorFactory.connect(url, envMap);
        }
        jmxConnector.connect();
        MBeanServerConnection server = jmxConnector.getMBeanServerConnection();
        this.jmxConnector = jmxConnector;
        this.connection = server;
        ObjectName name = new ObjectName(this.mBeanName);
        this.mbean = (ConfigurableAutomatedStartBean)JMX.newMBeanProxy(this.connection, name, this.clazz);
    }

    @Override
    public boolean isRunningOnTomcat() {
        return true;
    }
}

