/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.system;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.ReflectionException;

public class ServerUtil {
    public int tryToFindHttpPort(MBeanServerConnection connection) {
        Object o = this.tryToFindFromJBossBean(connection, "http");
        if (o == null) {
            o = this.tryToFindFromTomcatBean(connection, "HTTP/1.1");
        }
        return this.parseResult(o);
    }

    public int tryToFindHttpsPort(MBeanServerConnection connection) {
        Object o = this.tryToFindFromJBossBean(connection, "https");
        if (o == null) {
            o = this.tryToFindFromTomcatBean(connection, "HTTPS/1.1");
        }
        return this.parseResult(o);
    }

    private int parseResult(Object o) {
        if (o != null) {
            String p = o.toString();
            try {
                return Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private Object tryToFindFromJBossBean(MBeanServerConnection connection, String binding) {
        try {
            return connection.getAttribute(new ObjectName("jboss.as:socket-binding-group=standard-sockets,socket-binding=" + binding), "boundPort");
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            return null;
        }
    }

    private Object tryToFindFromTomcatBean(MBeanServerConnection connection, String protocol) {
        try {
            Set<ObjectName> objs = connection.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value(protocol)));
            Iterator<ObjectName> i = objs.iterator();
            if (i.hasNext()) {
                ObjectName obj = i.next();
                String port = obj.getKeyProperty("port");
                return port;
            }
        }
        catch (IOException | MalformedObjectNameException exception) {
            // empty catch block
        }
        return null;
    }
}

