/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.system;

import de.governikus.csc.system.ConfigurableAutomatedStartBean;
import de.governikus.csc.system.MBeanConnector;
import de.governikus.csc.system.ServerUtil;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMBeanConnector<T extends ConfigurableAutomatedStartBean>
implements MBeanConnector<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMBeanConnector.class);
    protected MBeanServerConnection connection;
    protected String mBeanName;
    protected String bufferedConfig;
    protected Class<T> clazz;
    protected T mbean;

    public AbstractMBeanConnector(String mBeanName, Class<T> clazz) {
        this.mBeanName = mBeanName;
        this.clazz = clazz;
    }

    @Override
    public void close() {
    }

    @Override
    public void restoreBufferedConfig() {
        if (this.bufferedConfig != null) {
            LOGGER.warn("Restoring buffered config for {}", (Object)this.mBeanName);
            this.mbean.configure(this.bufferedConfig);
            this.bufferedConfig = null;
        }
    }

    @Override
    public void restoreAndPersistBufferedConfig() {
        if (this.bufferedConfig != null) {
            LOGGER.warn("Restoring buffered config for {}", (Object)this.mBeanName);
            this.mbean.configureAndSave(this.bufferedConfig);
            this.bufferedConfig = null;
        }
    }

    @Override
    public void configure(String config) throws JMException, IOException {
        LOGGER.warn("Configuring {}", (Object)this.mBeanName);
        this.mbean.configure(config);
    }

    @Override
    public void bufferCurrentConfig() {
        this.bufferedConfig = this.mbean.getConfiguration();
    }

    @Override
    public T getMBean() {
        return this.mbean;
    }

    @Override
    public int getHttpPort() {
        ServerUtil serverUtil = new ServerUtil();
        return serverUtil.tryToFindHttpPort(this.connection);
    }

    @Override
    public int getHttpsPort() {
        ServerUtil serverUtil = new ServerUtil();
        return serverUtil.tryToFindHttpsPort(this.connection);
    }

    @Override
    public boolean isRunningOnTomcat() {
        return System.getProperty("catalina.base") != null;
    }
}

