/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.xml.auth.server;

import de.governikus.csc.config.auth.AttributeI;
import de.governikus.csc.config.auth.AuthenticationConfig;
import de.governikus.csc.config.xml.ComponentConfigurationProvider;
import de.governikus.csc.config.xml.auth.Attribute;
import de.governikus.csc.config.xml.auth.Role;
import de.governikus.csc.config.xml.auth.Server;
import de.governikus.csc.config.xml.auth.User;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AuthenticationConfig")
public class AuthenticationConfigType
implements AuthenticationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationConfigType.class);
    @XmlElement(name="server")
    private Server server;
    @XmlElement(name="user")
    private List<User> users = new ArrayList<User>();
    @XmlElement(name="role")
    private List<Role> roles = new ArrayList<Role>();

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> _users) {
        this.users = _users;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public void setServer(Server _server) {
        this.server = _server;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> _roles) {
        this.roles = _roles;
    }

    public static void main(String[] args) {
        try {
            ComponentConfigurationProvider<AuthenticationConfigType> configProvider1 = new ComponentConfigurationProvider<AuthenticationConfigType>(AuthenticationConfigType.class);
            try (InputStream is = ResourceUtil.getResourceAsStream((String)"configTest.xml");){
                configProvider1.loadConfig(is);
                AuthenticationConfigType configuration = configProvider1.getConfiguration();
                List<Role> roles = configuration.getRoles();
                List<User> users = configuration.getUsers();
                User user = users.get(0);
                System.out.println(user.getFirstname() + " ---- " + user.getSurname());
                List<Attribute> attributes = user.getAttributes();
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        System.out.println(attribute.getKey() + " ------ " + attribute.getValue());
                    }
                }
                for (Role role : roles) {
                    System.out.println("roleName: " + role.getRoleName());
                    List<Attribute> attributes1 = role.getAttributes();
                    if (attributes1 == null) continue;
                    for (AttributeI attributeI : attributes1) {
                        System.out.println(attributeI.getKey() + " ------ " + attributeI.getValue());
                    }
                }
                System.out.println(roles.size());
            }
            catch (IOException | XMLStreamException e) {
                LOG.error("xml loading error ", (Throwable)e);
            }
        }
        catch (JAXBException e) {
            LogHelper.logException(null, (Logger)LOG, (Throwable)e);
        }
    }
}

