/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.xml.auth;

import de.governikus.csc.config.auth.AttributeI;
import de.governikus.csc.config.auth.RoleI;
import de.governikus.csc.config.auth.UserI;
import de.governikus.csc.config.xml.auth.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="user")
public class User
implements UserI {
    private static final String SEPARATOR_VALUE = ";";
    @XmlElement(name="name")
    String name;
    @XmlElement(name="password")
    String password;
    @XmlElement(name="surname")
    private String surname;
    @XmlElement(name="firstname")
    private String firstname;
    @XmlAttribute(name="userID")
    private String userID;
    @XmlElement(name="organization")
    private String organization;
    @XmlElement(name="roleNames")
    private List<String> roleNames = new ArrayList<String>();
    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    private List<Attribute> attributes = new ArrayList<Attribute>();
    @XmlElement(name="tokenValidityIntervall")
    private int tokenValidityIntervall;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userid) {
        this.userID = userid;
    }

    @Override
    public String getFirstname() {
        return this.firstname;
    }

    @Override
    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Override
    public List<String> getRoleNames() {
        return this.roleNames;
    }

    @Override
    public void setRoleNames(List<String> roleNames) {
        this.roleNames = roleNames;
    }

    @Override
    public int getTokenValidityIntervall() {
        return this.tokenValidityIntervall;
    }

    @Override
    public void setTokenValidityIntervall(int intervall) {
        this.tokenValidityIntervall = intervall;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    private RoleI getRole(String rolename, List<? extends RoleI> roles) {
        Predicate<RoleI> predicate = c -> c.getRoleName().equals(rolename);
        Optional<RoleI> optional = roles.stream().filter(predicate).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return optional.get();
    }

    @Override
    public Map<String, Object> getPayloads(List<? extends RoleI> roles) {
        HashMap<String, Object> payloads = new HashMap<String, Object>();
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        HashMap<String, Object> userAttributeMap = new HashMap<String, Object>();
        userInfoMap.put("UserID", this.userID == null ? "" : this.userID);
        userInfoMap.put("Name", this.name == null ? "" : this.name);
        userInfoMap.put("UserFirstname", this.firstname == null ? "" : this.firstname);
        userInfoMap.put("UserSurname", this.surname == null ? "" : this.surname);
        payloads.put("UserInfo", userInfoMap);
        ArrayList rolesList = new ArrayList();
        List<String> tmpRoleNames = this.roleNames;
        if (tmpRoleNames.size() == 1 && tmpRoleNames.get(0).contains(SEPARATOR_VALUE)) {
            tmpRoleNames = Arrays.asList(tmpRoleNames.get(0).split(SEPARATOR_VALUE));
        }
        for (String string : tmpRoleNames) {
            RoleI role = this.getRole(string.trim(), roles);
            if (role == null) continue;
            HashMap<String, Object> roleMap = new HashMap<String, Object>();
            roleMap.put("RoleName", role.getRoleName());
            List<? extends AttributeI> roleAttributes = role.getAttributes();
            for (AttributeI attributeI : roleAttributes) {
                Object key = attributeI.getKey();
                if (roleMap.containsKey(key)) {
                    UUID randomUUID = UUID.randomUUID();
                    key = (String)key + randomUUID.toString().substring(23);
                }
                roleMap.put((String)key, attributeI.getValue());
            }
            rolesList.add(roleMap);
        }
        userAttributeMap.put("Roles", rolesList);
        for (AttributeI attributeI : this.attributes) {
            Object key = attributeI.getKey();
            if (userAttributeMap.containsKey(key)) {
                UUID randomUUID = UUID.randomUUID();
                key = (String)key + randomUUID.toString().substring(23);
            }
            userAttributeMap.put((String)key, attributeI.getValue());
        }
        if (!userAttributeMap.isEmpty()) {
            payloads.put("Attributes", userAttributeMap);
        }
        return payloads;
    }
}

