/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.xml;

import de.governikus.csc.config.TrustedIssuer;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TrustedIssuerType", propOrder={"certificate", "path"})
public class TrustedIssuerType
implements TrustedIssuer {
    @XmlElement(required=true)
    protected byte[] certificate;
    @XmlElement(required=false)
    protected String path;

    @Override
    public byte[] getCertificate() {
        this.updateCertificateFromPath();
        return this.certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCertificateFromPath() {
        if (this.certificate != null && this.certificate.length > 0) {
            return;
        }
        URL url = TrustedIssuerType.getURL(this.path);
        if (url == null) {
            return;
        }
        try {
            CertificateFactory cf = Security.getProvider("BC") == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", "BC");
            try (InputStream is = url.openStream();){
                Certificate generateCertificate = cf.generateCertificate(is);
                TrustedIssuerType trustedIssuerType = this;
                synchronized (trustedIssuerType) {
                    this.certificate = generateCertificate.getEncoded();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static URL getURL(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        try {
            URL url = TrustedIssuerType.class.getResource(path);
            if (url == null) {
                url = TrustedIssuerType.class.getResource("/" + path);
            }
            if (url == null && path.contains("/")) {
                File file;
                Object cp = path;
                if (!((String)cp).startsWith("file:/")) {
                    cp = "file:/" + (String)cp;
                }
                if ((file = new File(new URI((String)cp))).exists() && file.isFile()) {
                    url = file.toURI().toURL();
                }
            }
            return url;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return null;
        }
    }

    @Override
    public void setCertificate(byte[] value) {
        this.certificate = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.certificate);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrustedIssuerType other = (TrustedIssuerType)obj;
        if (!Arrays.equals(this.certificate, other.certificate)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }
}

