/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.xml;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csc.config.ConfigurationProvider;
import de.governikus.csc.config.ConfigurationProviderBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class ComponentConfigurationProvider<T>
extends ConfigurationProviderBase<T>
implements ConfigurationProvider<T> {
    protected T config;
    private Unmarshaller unmarshaller;
    private ObjectMapper mapper;
    private Class<? extends T> type;

    public ComponentConfigurationProvider(Class<? extends T> t) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{t});
        this.unmarshaller = context.createUnmarshaller();
        this.mapper = new ObjectMapper();
        this.type = t;
    }

    @Override
    public T getConfiguration() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.config != null;
    }

    public void loadConfig(String file) throws JAXBException, IOException, XMLStreamException {
        try (InputStream is = ComponentConfigurationProvider.class.getResourceAsStream("/" + file);){
            if (is == null) {
                throw new IOException("Can not load resource: " + file);
            }
            this.loadConfig(is);
        }
    }

    public void loadConfig(File file) throws JAXBException, IOException, XMLStreamException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.loadConfig(fis);
        }
    }

    public void loadConfig(InputStream is) throws JAXBException, XMLStreamException {
        this.config = this.loadConfigFromStream(is);
        this.fireConfigChanged(this.config);
    }

    public void loadConfigJSON(InputStream is) throws IOException {
        this.config = this.mapper.readValue(is, this.type);
        this.fireConfigChanged(this.config);
    }

    public void loadConfigJSON(String jsonConfiguration) throws IOException {
        this.config = this.mapper.readValue(jsonConfiguration, this.type);
        this.fireConfigChanged(this.config);
    }

    public InputStream saveConfigToJSON(T configuration) throws IOException {
        String configAsString = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(configuration);
        ByteArrayInputStream is = new ByteArrayInputStream(configAsString.getBytes("UTF-8"));
        this.config = configuration;
        this.fireConfigChanged(configuration);
        return is;
    }

    protected T loadConfigFromStream(InputStream is) throws JAXBException, XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        return (T)this.unmarshaller.unmarshal(xif.createXMLStreamReader(is));
    }

    public void setConfig(T config) {
        this.config = config;
        this.fireConfigChanged(config);
    }
}

