/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.util;

import de.governikus.csc.config.xml.TrustedIssuerType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedIssuerTypeConverterUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedIssuerTypeConverterUtil.class);
    private CertificateFactory certFactory = CertificateFactory.getInstance("x509");

    public List<TrustedIssuerType> trustedIssuerTypeFromString(String certPathsAndOrNames) {
        List certs = Arrays.asList(certPathsAndOrNames.split(",")).stream().map(String::trim).collect(Collectors.toList());
        ArrayList<TrustedIssuerType> trustedIssuerTypes = new ArrayList<TrustedIssuerType>();
        for (String cert : certs) {
            try {
                trustedIssuerTypes.add(this.createTrustedIssuerType(cert));
            }
            catch (IOException e) {
                LOGGER.error("TrustedIssuer not found at {}", (Object)cert, (Object)e);
                return null;
            }
            catch (CertificateException e) {
                LOGGER.error("Cannot parse file at {} as TrustedIssuer", (Object)cert, (Object)e);
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing TrustedIssuer at {}", (Object)cert, (Object)e);
                return null;
            }
        }
        return trustedIssuerTypes;
    }

    private TrustedIssuerType createTrustedIssuerType(String cert) throws FileNotFoundException, IOException, CertificateException {
        if (cert.startsWith("classpath:")) {
            String resourceName = cert.substring(cert.indexOf(58) + 1);
            return this.loadFromClasspath(resourceName);
        }
        return this.loadFromFile(cert);
    }

    private TrustedIssuerType loadFromClasspath(String resourceName) throws IOException, CertificateException {
        try (InputStream certIn = TrustedIssuerTypeConverterUtil.class.getClassLoader().getResourceAsStream(resourceName);){
            TrustedIssuerType trustedIssuerType = this.createTrustedIssuerType(certIn);
            return trustedIssuerType;
        }
    }

    private TrustedIssuerType loadFromFile(String certPath) throws FileNotFoundException, IOException, CertificateException {
        try (FileInputStream certIn = new FileInputStream(certPath);){
            TrustedIssuerType trustedIssuerType = this.createTrustedIssuerType(certIn);
            return trustedIssuerType;
        }
    }

    private TrustedIssuerType createTrustedIssuerType(InputStream certIn) throws CertificateException {
        TrustedIssuerType trustedIssuerType = new TrustedIssuerType();
        X509Certificate x509Cert = (X509Certificate)this.certFactory.generateCertificate(certIn);
        trustedIssuerType.setCertificate(x509Cert.getEncoded());
        return trustedIssuerType;
    }
}

