/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config.util;

import de.governikus.csc.config.DatabaseConfiguration;
import de.governikus.csc.config.util.InvalidPersistenceConfigurationException;
import de.governikus.csc.config.util.PersistenceInitalizationException;
import de.governikus.csc.config.xml.crl.DatabaseConfigurationType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSCPersistenceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSCPersistenceUtil.class);

    public static EntityManagerFactory createEntityManagerFactory(String unitName, DatabaseConfiguration dbConfig) throws PersistenceInitalizationException {
        CSCPersistenceUtil.logSettings(dbConfig);
        Properties properties = new Properties();
        String jndiDataSource = dbConfig.getJNDIDataSource();
        if (jndiDataSource != null && jndiDataSource.length() > 0) {
            properties.put("hibernate.connection.datasource", jndiDataSource);
        } else {
            String username = dbConfig.getUsername();
            String password = dbConfig.getPassword();
            String driver = dbConfig.getDriver();
            String url = dbConfig.getURL();
            if (username == null || driver == null || url == null) {
                throw new InvalidPersistenceConfigurationException("Some required configuration parameters are missing");
            }
            properties.put("hibernate.connection.username", username);
            if (password != null) {
                properties.put("hibernate.connection.password", password);
            }
            properties.put("hibernate.connection.driver_class", driver);
            properties.put("hibernate.connection.url", url);
        }
        CSCPersistenceUtil.setCrlDownloaderHibernateTimezone(unitName, properties);
        properties.put("hibernate.dialect", dbConfig.getDialect());
        properties.put("hibernate.hbm2ddl.auto", "validate");
        properties.put("hibernate.show_sql", "false");
        properties.put("hibernate.format_sql", "true");
        properties.put("hibernate.c3p0.min_size", "5");
        properties.put("hibernate.c3p0.max_size", "20");
        properties.put("hibernate.c3p0.timeout", "300");
        properties.put("hibernate.c3p0.max_statements", "50");
        properties.put("hibernate.c3p0.idle_test_period", "3000");
        properties.put("hibernate.connection.isolation", "2");
        try {
            return Persistence.createEntityManagerFactory((String)unitName, (Map)properties);
        }
        catch (Exception e) {
            String msg = "Error can not create entity manager factory";
            throw new PersistenceInitalizationException(msg, e);
        }
    }

    private static void setCrlDownloaderHibernateTimezone(String unitName, Properties properties) {
        if ("crlDownloaderPersistence".equals(unitName)) {
            properties.put("hibernate.jdbc.time_zone", "UTC");
        }
    }

    private static void logSettings(DatabaseConfiguration dbConfig) {
        LOGGER.info("Database connection parameter:");
        if (dbConfig.getJNDIDataSource() != null) {
            LOGGER.info(" - JNDI-Datasource = {}", (Object)dbConfig.getJNDIDataSource());
        } else {
            LOGGER.info(" - URL = {}", (Object)dbConfig.getURL());
            LOGGER.info(" - Username = {}", (Object)dbConfig.getUsername());
            LOGGER.info(" - Driver = {}", (Object)dbConfig.getDriver());
        }
        LOGGER.info(" - Dialect = {}", (Object)dbConfig.getDialect());
    }

    public Connection getJDBCConnection(DatabaseConfigurationType dbConfig) throws SQLException, NamingException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection connection;
        if (dbConfig.getJNDIDataSource() != null && dbConfig.getJNDIDataSource().trim().length() > 0) {
            InitialContext context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup("jdbc/DataSource");
            connection = dataSource.getConnection();
        } else {
            Class.forName(dbConfig.getDriver()).newInstance();
            connection = DriverManager.getConnection(dbConfig.getURL(), dbConfig.getUsername(), dbConfig.getPassword());
        }
        return connection;
    }
}

