/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config;

import de.governikus.csc.config.TrustedIssuer;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedIssuerUtil {
    public static final String CERT_STORE_TYPE_COLLECTION = "Collection";
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedIssuerUtil.class);

    private TrustedIssuerUtil() {
    }

    public static CertStore createCertStore(List<?> certificates) {
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(certificates);
        try {
            return CertStore.getInstance(CERT_STORE_TYPE_COLLECTION, (CertStoreParameters)certStoreParameters, CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                return CertStore.getInstance(CERT_STORE_TYPE_COLLECTION, (CertStoreParameters)certStoreParameters, "BC");
            }
            catch (Exception e2) {
                LOGGER.error("CertStore could not be created", (Throwable)e2);
                return null;
            }
        }
    }

    public static List<Object> getCertificates(List<TrustedIssuer> trustedIssuers) {
        ArrayList<Object> certificates = new ArrayList<Object>();
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509", CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                cf = CertificateFactory.getInstance("X.509", "BC");
            }
            catch (Exception e2) {
                LOGGER.error("Couldn't get CertificateFacotory Instance.", (Throwable)e2);
            }
        }
        if (cf == null) {
            return certificates;
        }
        for (TrustedIssuer trustedIssuer : trustedIssuers) {
            try {
                certificates.add(cf.generateCertificate(new ByteArrayInputStream(trustedIssuer.getCertificate())));
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't get Certificate.", (Throwable)e);
            }
        }
        return certificates;
    }
}

