/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config;

import de.governikus.csc.config.ConfigListener;
import de.governikus.csc.config.ConfigurationProvider;
import de.governikus.csc.config.FileManagerClientConfiguration;
import de.governikus.csc.config.FileManagerOfflineClient;
import de.governikus.csc.config.MailConfiguration;
import de.governikus.csc.config.ResponseSigningConfiguration;
import de.governikus.csc.config.TrustedIssuer;
import de.governikus.csc.config.cvs.CVSConfiguration;
import de.governikus.csc.config.cvs.CacheConfiguration;
import de.governikus.csc.config.cvs.ForwardingConfiguration;
import de.governikus.csc.config.cvs.TrustedIssuersConfiguration;
import de.governikus.csc.config.xml.MailConfigurationType;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StaticConfigurationProvider
implements ConfigurationProvider<CVSConfiguration> {
    @Override
    public CVSConfiguration getConfiguration() {
        return new CVSConfiguration(){

            @Override
            public CacheConfiguration getCacheConfiguration() {
                return new CacheConfiguration(){

                    @Override
                    public int getMaxCacheTime() {
                        return 1800000;
                    }

                    @Override
                    public String getCacheName() {
                        return "revocationValueCache";
                    }
                };
            }

            @Override
            public ProxyConfiguration getProxyConfiguration() {
                return new ProxyConfiguration(){

                    public List<String> getProxyExceptions() {
                        return Collections.singletonList("10.211.1.70");
                    }

                    public String getUsername() {
                        return null;
                    }

                    public int getProxyPort() {
                        return 65111;
                    }

                    public String getProxyHost() {
                        return "192.168.0.7";
                    }

                    public String getPassword() {
                        return null;
                    }

                    public boolean isNoCacheHeader() {
                        return false;
                    }

                    public boolean isLDAPProxy() {
                        return false;
                    }
                };
            }

            @Override
            public MailConfiguration getMailConfiguration() {
                return new MailConfiguration(){

                    @Override
                    public boolean hasMailAuthCredentials() {
                        return true;
                    }

                    @Override
                    public String getMailUsername() {
                        return "username";
                    }

                    @Override
                    public String getMailSender() {
                        return "get@Mail.Sender";
                    }

                    @Override
                    public List<String> getMailRecipients() {
                        ArrayList<String> recpients = new ArrayList<String>();
                        recpients.add("get@Mail.Recipients");
                        return recpients;
                    }

                    @Override
                    public String getMailPort() {
                        return "25";
                    }

                    @Override
                    public String getMailPassword() {
                        return "password";
                    }

                    @Override
                    public String getMailHost() {
                        return "host";
                    }

                    public int hashCode() {
                        return Objects.hash(this.getMailSender(), this.getMailRecipients(), this.getMailHost(), this.getMailPassword(), this.getMailPort(), this.getMailUsername());
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        MailConfigurationType other = (MailConfigurationType)obj;
                        return Objects.equals(this.getMailHost(), other.getMailHost()) && Objects.equals(this.getMailPassword(), other.getMailPassword()) && Objects.equals(this.getMailPort(), other.getMailPort()) && Objects.equals(this.getMailSender(), other.getMailSender()) && Objects.equals(this.getMailUsername(), other.getMailUsername());
                    }
                };
            }

            @Override
            public ForwardingConfiguration getForwardingConfiguration() {
                return null;
            }

            @Override
            public TrustedIssuersConfiguration getTrustedIssuersConfiguration() {
                return null;
            }

            @Override
            public String getCRLDownloaderURL() {
                return null;
            }

            @Override
            public List<String> getSupportedCountryCodes() {
                ArrayList<String> list = new ArrayList<String>();
                list.add("DE");
                list.add("FR");
                return list;
            }

            @Override
            public String getDefaultAlgorithmCatalogCountryCode() {
                return "DE";
            }

            @Override
            public FileManagerClientConfiguration getFilemanagerConfiguration() {
                return null;
            }

            @Override
            public ResponseSigningConfiguration getSigningConfiguration() {
                return null;
            }

            @Override
            public FileManagerOfflineClient getOfflineFilemanagerConfiguration() {
                return null;
            }

            @Override
            public List<? extends TrustedIssuer> getCRLDownloaderSSLCertificates() {
                return null;
            }
        };
    }

    @Override
    public void addConfigListener(ConfigListener configListener) {
    }

    @Override
    public void removeConfigListener(ConfigListener<? super CVSConfiguration> configListener) {
    }
}

