/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.config;

import de.governikus.csc.config.ConfigListener;
import de.governikus.csc.config.ConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationProviderBase<T>
implements ConfigurationProvider<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationProviderBase.class);
    private List<ConfigListener<? super T>> listener = new ArrayList<ConfigListener<? super T>>();

    @Override
    public void addConfigListener(ConfigListener<? super T> configListener) {
        this.listener.add(configListener);
    }

    @Override
    public void removeConfigListener(ConfigListener<? super T> configListener) {
        this.listener.remove(configListener);
    }

    protected void fireConfigChanged(T newConfig) {
        for (ConfigListener<T> l : this.listener) {
            try {
                l.configurationChanged(newConfig);
            }
            catch (Throwable t) {
                LOGGER.error("configuration change not active", t);
            }
        }
    }
}

