/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util.jdk11;

import de.governikus.csl.remote.sign.bnotk.BNotKHttpFacade;
import de.governikus.csl.remote.sign.bnotk.util.BNotKMCardHelper;
import de.governikus.csl.remote.sign.bnotk.util.jdk11.JDK11CloseableHttpResponse;
import de.governikus.csl.transport.ApacheHttpEntityFacade;
import de.governikus.csl.transport.ApacheHttpResponse;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.uom.types.ProxyConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDK11HttpFacadeImpl
implements BNotKHttpFacade {
    private static final Logger LOG = LoggerFactory.getLogger(JDK11HttpFacadeImpl.class);
    private boolean cardContextFlag;

    public static HttpClient.Builder addProxy(HttpClient.Builder httpClientBuilder, final ProxyConfiguration proxyConfiguration) {
        httpClientBuilder.proxy(JDK11HttpFacadeImpl.createProxySelector(proxyConfiguration));
        if (proxyConfiguration != null && !proxyConfiguration.getUsername().isBlank() && !proxyConfiguration.getPassword().isBlank()) {
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyConfiguration.getUsername(), proxyConfiguration.getPassword().toCharArray());
                }
            };
            httpClientBuilder.authenticator(authenticator);
        }
        return httpClientBuilder;
    }

    public static byte[] checkResponse(HttpResponse<byte[]> httpResponse, String message) {
        byte[] body = httpResponse.body();
        switch (httpResponse.statusCode()) {
            case 200: {
                return body;
            }
            case 401: {
                throw new IllegalStateException("HTTP 401 Unauthorized - " + message);
            }
            case 403: {
                throw new IllegalStateException("HTTP 403 Forbidden - " + message);
            }
        }
        if (body.length == 0) {
            throw new IllegalStateException(message + ": " + httpResponse.toString());
        }
        throw new IllegalStateException(message + ": " + new String(body));
    }

    private static ProxySelector createProxySelector(final ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration == null || proxyConfiguration.getProxyHost().isBlank()) {
            return ProxySelector.getDefault();
        }
        final ProxySelector proxySelector = ProxySelector.of(new InetSocketAddress(proxyConfiguration.getProxyHost(), proxyConfiguration.getProxyPort()));
        final List<Proxy> noProxies = Arrays.asList(Proxy.NO_PROXY);
        return new ProxySelector(){

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException e) {
            }

            @Override
            public List<Proxy> select(URI uri) {
                List nonProxyHosts = proxyConfiguration.getNonProxyHosts();
                if (nonProxyHosts != null && !nonProxyHosts.isEmpty() && nonProxyHosts.stream().anyMatch(e -> uri.toString().contains((CharSequence)e))) {
                    return noProxies;
                }
                return proxySelector.select(uri);
            }
        };
    }

    public static SSLContext getDefaultSslContext() throws IOException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static java.net.http.HttpClient getHttpClient(ProxyConfiguration proxyConfiguration, boolean cardContext) throws IOException {
        java.net.http.HttpClient httpClient;
        if (cardContext) {
            SSLParameters sslParameters = new SSLParameters();
            sslParameters.setNeedClientAuth(true);
            sslParameters.setWantClientAuth(true);
            httpClient = JDK11HttpFacadeImpl.addProxy(java.net.http.HttpClient.newBuilder().sslContext(JDK11HttpFacadeImpl.getIdpSslContext()).sslParameters(sslParameters), proxyConfiguration).build();
        } else {
            httpClient = JDK11HttpFacadeImpl.addProxy(java.net.http.HttpClient.newBuilder().sslContext(JDK11HttpFacadeImpl.getDefaultSslContext()), proxyConfiguration).build();
        }
        return httpClient;
    }

    public static SSLContext getIdpSslContext() throws IOException {
        try {
            KeyStore keyStore = BNotKMCardHelper.getMCardKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2", "BCJSSE");
            sslContext.init(kmf.getKeyManagers(), null, null);
            SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
            supportedSSLParameters.setWantClientAuth(true);
            supportedSSLParameters.setNeedClientAuth(true);
            LOG.info("{}", Arrays.asList(supportedSSLParameters.getCipherSuites()));
            LOG.info("{}", Arrays.asList(supportedSSLParameters.getCipherSuites()));
            LOG.info("{}", Arrays.asList(supportedSSLParameters.getApplicationProtocols()));
            LOG.info("{}", Arrays.asList(supportedSSLParameters.getAlgorithmConstraints()));
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new IOException(e);
        }
    }

    public JDK11HttpFacadeImpl() {
        this(false);
    }

    public JDK11HttpFacadeImpl(boolean cardContextFlag) {
        this.cardContextFlag = cardContextFlag;
    }

    private HttpRequest.Builder addHeaders(HttpRequest.Builder builder, HttpHeader ... headers) {
        if (headers == null || headers.length == 0) {
            return builder;
        }
        for (HttpHeader header : headers) {
            builder.header(header.getName(), header.getValue());
        }
        return builder;
    }

    private HttpRequest.BodyPublisher createPublisher(HttpRequest entity) throws IOException {
        if (entity instanceof ByteArrayRequest) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ((ByteArrayRequest)entity).writeTo((OutputStream)baos);
                HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(baos.toByteArray());
                return bodyPublisher;
            }
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    @Override
    public de.governikus.csl.transport.HttpResponse delete(URI uri, HttpHeader ... headers) throws ConnectionException {
        java.net.http.HttpRequest request = this.addHeaders(java.net.http.HttpRequest.newBuilder(uri).DELETE(), headers).build();
        return new ApacheHttpResponse(this.doRequest(request, false));
    }

    @Override
    public BNotKHttpFacade deriveBNotK(String jceProviderName, KeyStore clientKeyStore) {
        return new JDK11HttpFacadeImpl(true);
    }

    @Override
    public CloseableHttpResponse doRequest(HttpRequestBase request, HttpClientContext context, ApacheHttpEntityFacade entity, HttpHeader ... headers) throws IOException, InvalidCredentialsException {
        throw new UnsupportedOperationException();
    }

    private CloseableHttpResponse doRequest(java.net.http.HttpRequest request, boolean responseContentExpected) {
        HttpResponse<byte[]> response = this.sendRetrieve(request, responseContentExpected);
        return new JDK11CloseableHttpResponse(responseContentExpected, response);
    }

    @Override
    public de.governikus.csl.transport.HttpResponse get(URI uri, HttpHeader ... headers) throws ConnectionException {
        return new ApacheHttpResponse(this.getIt(uri, headers));
    }

    @Override
    public HttpClient getHttpClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CloseableHttpResponse getIt(URI uri, HttpHeader ... headers) throws ConnectionException {
        java.net.http.HttpRequest request = this.addHeaders(java.net.http.HttpRequest.newBuilder(uri).GET(), headers).build();
        return this.doRequest(request, true);
    }

    @Override
    public de.governikus.csl.transport.HttpResponse post(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        return new ApacheHttpResponse(this.postIt(uri, entity, headers));
    }

    @Override
    public CloseableHttpResponse postIt(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        try {
            java.net.http.HttpRequest request = this.addHeaders(java.net.http.HttpRequest.newBuilder(uri).POST(this.createPublisher(entity)), headers).build();
            return this.doRequest(request, true);
        }
        catch (IOException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    @Override
    public de.governikus.csl.transport.HttpResponse put(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        return new ApacheHttpResponse(this.putIt(uri, entity, headers));
    }

    @Override
    public CloseableHttpResponse putIt(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        try {
            java.net.http.HttpRequest request = this.addHeaders(java.net.http.HttpRequest.newBuilder(uri).PUT(this.createPublisher(entity)), headers).build();
            return this.doRequest(request, true);
        }
        catch (IOException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    private HttpResponse<byte[]> sendRetrieve(java.net.http.HttpRequest request, boolean responseContentExpected) {
        HttpResponse<byte[]> response;
        try {
            java.net.http.HttpClient httpClient = JDK11HttpFacadeImpl.getHttpClient(null, this.cardContextFlag);
            HttpResponse.BodyHandler<Object> responseBodyHandler = null;
            responseBodyHandler = responseContentExpected ? HttpResponse.BodyHandlers.ofByteArray() : null;
            response = httpClient.send(request, responseBodyHandler);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("failed to send request: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to send request: " + e.getMessage(), e);
        }
        JDK11HttpFacadeImpl.checkResponse(response, "failed with request to " + request.uri());
        return response;
    }
}

