/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util.jdk11;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpParams;

public class JDK11CloseableHttpResponse
implements CloseableHttpResponse {
    private final HttpEntity entity;
    private final HeaderGroup headerGroup;
    private final HttpResponse<byte[]> response;

    private static HeaderGroup toApache(HttpHeaders headers) {
        HeaderGroup headerGroup = new HeaderGroup();
        if (headers != null && !headers.map().isEmpty()) {
            headers.map().forEach((k, v) -> headerGroup.addHeader((Header)new BasicHeader(k, v.toString())));
        }
        return headerGroup;
    }

    public JDK11CloseableHttpResponse(boolean responseContentExpected, HttpResponse<byte[]> response) {
        this.response = response;
        this.headerGroup = JDK11CloseableHttpResponse.toApache(response.headers());
        Object tmp = responseContentExpected ? new ByteArrayEntity(response.body()) : new StringEntity("", StandardCharsets.UTF_8);
        this.entity = tmp;
    }

    public void addHeader(Header header) {
        throw new UnsupportedOperationException();
    }

    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    public boolean containsHeader(String name) {
        return this.headerGroup.containsHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headerGroup.getAllHeaders();
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public Header getFirstHeader(String name) {
        return this.headerGroup.getFirstHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headerGroup.getHeaders(name);
    }

    public Header getLastHeader(String name) {
        return this.headerGroup.getLastHeader(name);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Deprecated(since="4.3")
    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ProtocolVersion getProtocolVersion() {
        HttpClient.Version version = this.response.version();
        return new ProtocolVersion(this.response.uri().getScheme(), HttpClient.Version.HTTP_1_1 == version ? 1 : 2, HttpClient.Version.HTTP_1_1 == version ? 1 : 0);
    }

    public StatusLine getStatusLine() {
        return new BasicStatusLine(this.getProtocolVersion(), this.response.statusCode(), this.response.toString());
    }

    public HeaderIterator headerIterator() {
        return this.headerGroup.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headerGroup.iterator(name);
    }

    public void removeHeader(Header header) {
        throw new UnsupportedOperationException();
    }

    public void removeHeaders(String name) {
        throw new UnsupportedOperationException();
    }

    public void setEntity(HttpEntity entity) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(Header header) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Header[] headers) {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(since="4.3")
    public void setParams(HttpParams params) {
        throw new UnsupportedOperationException();
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void setStatusCode(int code) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        throw new UnsupportedOperationException();
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        throw new UnsupportedOperationException();
    }

    public void setStatusLine(StatusLine statusline) {
        throw new UnsupportedOperationException();
    }
}

