/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.CertificateLoader;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCardDefaultCertificateLoader
implements CertificateLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MCardDefaultCertificateLoader.class);

    public Certificate loadCertificate(byte[] data) {
        byte[] certDataBytes = data;
        try {
            ASN1 fc;
            ASN1 a = new ASN1(data);
            if (a.getChildElementCount() >= 1 && (fc = (ASN1)a.getChildElementList().get(0)).getDTag().intValue() == 6 && a.getChildElementCount() >= 2) {
                certDataBytes = ((ASN1)a.getChildElementList().get(1)).getEncoded();
            }
        }
        catch (Exception a) {
            // empty catch block
        }
        byte[] certBytes = certDataBytes;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            return cf.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("certificate factory of provider BC failed generating certificate", (Throwable)ex);
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "SUN");
                return cf.generateCertificate(new ByteArrayInputStream(certBytes));
            }
            catch (Exception ex2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("certificate factory of provider SUN failed generating certificate", (Throwable)ex2);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    return cf.generateCertificate(new ByteArrayInputStream(certBytes));
                }
                catch (Exception ex3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("certificate factory of provider default failed generating certificate", (Throwable)ex3);
                    }
                    return null;
                }
            }
        }
    }
}

