/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Sequence;

public final class BNotKTokenHelper {
    public static final String DATE_2_OFFSET_DATE_TIME_PATTERN = "yyyy-MM-dd'T'kk:mm:ss.SSSSSSSSSXXX";

    private BNotKTokenHelper() {
    }

    public static ZonedDateTime getValidToDate(byte[] tokenBytes) throws IOException {
        try {
            return BNotKTokenHelper.convertDate2ZonedDateTime(((ASN1GeneralizedTime)BNotKTokenHelper.getElement(tokenBytes, 0, 2)).getDate());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static ZonedDateTime getValidFromDate(byte[] tokenBytes) throws IOException {
        try {
            return BNotKTokenHelper.convertDate2ZonedDateTime(((ASN1GeneralizedTime)BNotKTokenHelper.getElement(tokenBytes, 0, 1)).getDate());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static ASN1Encodable getElement(byte[] bytes, int ... indices) {
        return BNotKTokenHelper.getElement(ASN1Sequence.getInstance((Object)bytes), indices);
    }

    public static ASN1Encodable getElement(ASN1Sequence sequence, int ... indices) {
        int index;
        ASN1Sequence result = sequence;
        if (indices == null || indices.length == 0) {
            return result;
        }
        int[] nArray = indices;
        int n = nArray.length;
        for (int i = 0; i < n && (result = result.getObjectAt(index = nArray[i])) instanceof ASN1Sequence; ++i) {
        }
        return result;
    }

    public static ZonedDateTime convertDate2ZonedDateTime(Date date) {
        return BNotKTokenHelper.convertDate2ZonedDateTime(new SimpleDateFormat(DATE_2_OFFSET_DATE_TIME_PATTERN).format(date));
    }

    public static ZonedDateTime convertDate2ZonedDateTime(String offsetDateTimeString) {
        return OffsetDateTime.parse(offsetDateTimeString).toZonedDateTime();
    }
}

