/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util;

import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.CertificateLoader;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.governikus.csl.remote.sign.bnotk.BNotKServiceConstants;
import de.governikus.csl.remote.sign.bnotk.util.MCardDefaultCertificateLoader;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.ResourceFailedException;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BNotKMCardHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BNotKMCardHelper.class);
    private static final String MCARD_ALIAS_PREFIX_CARD_HANDLE = "card_at_terminal_'";

    public static Optional<OCFPrivateKey> findFirstOCFPrivateKey(Card card) {
        KeyStore keyStore = BNotKMCardHelper.getMCardKeyStore();
        return BNotKMCardHelper.getAliases(keyStore).stream().filter(a -> BNotKMCardHelper.isBNotKCardKey(card, keyStore, a)).map(a -> {
            try {
                return (OCFPrivateKey)keyStore.getKey((String)a, null);
            }
            catch (Exception e) {
                return null;
            }
        }).findFirst();
    }

    public static Optional<OCFPrivateKey> findFirstOCFPrivateKey() {
        KeyStore keyStore = BNotKMCardHelper.getMCardKeyStore();
        return BNotKMCardHelper.getAliases(keyStore).stream().filter(a -> BNotKMCardHelper.isBNotKCardKey(null, keyStore, a)).map(a -> {
            try {
                return (OCFPrivateKey)keyStore.getKey((String)a, null);
            }
            catch (Exception e) {
                return null;
            }
        }).findFirst();
    }

    public static List<String> getAliases(KeyStore keyStore) {
        try {
            return Collections.list(keyStore.aliases());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static KeyStore getMCardKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance("OCF", "OCF");
            keyStore.load(null, null);
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to retrieve MCard key store: " + e.getMessage(), e);
        }
    }

    public static boolean initCardKey(Card card) {
        Optional<OCFPrivateKey> keyOptional = BNotKMCardHelper.findFirstOCFPrivateKey(card);
        if (keyOptional.isPresent()) {
            return BNotKMCardHelper.initCardKey(keyOptional.get());
        }
        return false;
    }

    public static boolean initCardKey(KeyStore keyStore, String keyAlias) {
        boolean result;
        LOG.info("key: {}", (Object)keyAlias);
        try {
            result = BNotKMCardHelper.initCardKey(BNotKMCardHelper.requiresBNotKOCFPrivateKey(keyStore.getKey(keyAlias, null)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean initCardKey(OCFPrivateKey key) {
        boolean result = false;
        try {
            Signature s = Signature.getInstance("SHA256withRSAandMGF1", "OCF");
            s.initSign((PrivateKey)key);
            byte[] digest = MessageDigest.getInstance("SHA256").digest();
            s.update(digest, 0, digest.length);
            byte[] signatureValue = s.sign();
            LOG.info("signature value: {}", (Object)signatureValue.length);
            result = signatureValue.length > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean initCardKey(Optional<String> keyAliasOptional, KeyStore keyStore) {
        if (!keyAliasOptional.isPresent()) {
            return false;
        }
        String keyAlias = keyAliasOptional.get();
        LOG.info("key: {}", (Object)keyAlias);
        return BNotKMCardHelper.initCardKey(keyStore, keyAlias);
    }

    public static boolean initCardKey(PrivateKeyResource keyResource) {
        return BNotKMCardHelper.initCardKey(BNotKMCardHelper.requiresBNotKOCFPrivateKey(keyResource));
    }

    public static KeyStore initMCardKeyStore(CardListener cardListener) throws IOException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("OCF", "OCF");
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            throw new IOException(e);
        }
        BNotKMCardHelper.startMCard(cardListener, keyStore);
        return keyStore;
    }

    private static void startMCard(CardListener cardListener, KeyStore keyStore) throws IOException {
        try (OCFKeyStoreParameterInputStream is = new OCFKeyStoreParameterInputStream();){
            is.setOwnerWindow((Object)new Frame());
            is.setOCFProperties(new Properties());
            is.setCertLoader((CertificateLoader)new MCardDefaultCertificateLoader());
            CardObjectRegistryImpl.getInstance().addCardListener(cardListener);
            keyStore.load((InputStream)is, null);
            Thread.sleep(2500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
    }

    public static boolean isBnotKCard(Card card) {
        return BNotKServiceConstants.BNOTK_CARD_TYPE.getType() == card.getType();
    }

    public static boolean isBNotKCardKey(Card card, KeyStore keyStore, String alias) {
        try {
            return !alias.startsWith(MCARD_ALIAS_PREFIX_CARD_HANDLE) && keyStore.isKeyEntry(alias) && (card == null || card == BNotKMCardHelper.requiresBNotKOCFPrivateKey(keyStore.getKey(alias, null)).getCardService().getCardObject());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static OCFPrivateKey requiresBNotKOCFPrivateKey(Key key) {
        if (key instanceof OCFPrivateKey) {
            OCFPrivateKey ocfPrivateKey = (OCFPrivateKey)key;
            if (BNotKMCardHelper.isBnotKCard(ocfPrivateKey.getCardService().getCardObject())) {
                return ocfPrivateKey;
            }
            throw new IllegalArgumentException("BNotK card is required");
        }
        throw new IllegalArgumentException("key of MCard is required");
    }

    public static OCFPrivateKey requiresBNotKOCFPrivateKey(PrivateKeyResource keyResource) {
        PrivateKey key;
        try {
            key = (PrivateKey)keyResource.getKey();
        }
        catch (ResourceFailedException e) {
            throw new IllegalArgumentException("key of resource is not accessible", e);
        }
        return BNotKMCardHelper.requiresBNotKOCFPrivateKey(key);
    }

    private BNotKMCardHelper() {
    }
}

