/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.util;

import de.governikus.csl.transport.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BNotKHelper {
    private static final String ERROR_MESSAGE_PREFIX_HTTP = "HTTP ";
    private static final Logger LOG = LoggerFactory.getLogger(BNotKHelper.class);

    public static void assertValidProviderOrderForTLS() {
        try {
            if ("BCJSSE".equals(SSLContext.getInstance("TLSv1.2").getProvider().getName())) {
                throw new IllegalArgumentException("JCE security provider setup is invalid, for default SSL context MCard specific enhanced provider BCJSSE must not be used");
            }
            LOG.info("card TLS provider registered in valid order to work");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("TLS SSL context can not be instantiated: " + e.getMessage(), e);
        }
    }

    public static KeyPair generateSADKeyPair() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec("secp521r1"));
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static byte[] checkResponse(HttpResponse httpResponse, String message) throws IOException {
        byte[] body;
        try (InputStream is = httpResponse.getContent();
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)baos);
            body = baos.toByteArray();
        }
        switch (httpResponse.getStatus()) {
            case 200: {
                if (body == null || body.length == 0) {
                    throw new IllegalStateException(message + ": no content received");
                }
                return body;
            }
            case 401: {
                throw new IllegalStateException("HTTP 401 Unauthorized - " + httpResponse.getStatusReason() + " - " + message);
            }
            case 403: {
                throw new IllegalStateException("HTTP 403 Forbidden - " + httpResponse.getStatusReason() + " - " + message);
            }
        }
        throw new IllegalStateException(ERROR_MESSAGE_PREFIX_HTTP + httpResponse.getStatus() + " " + httpResponse.getStatusReason() + " - " + message + (String)(body == null || body.length == 0 ? "" : ": " + new String(body)));
    }

    public static byte[] generateSadSignature(PrivateKey sadSignatureKey, byte[] sadTbs) throws IOException {
        try {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(sadSignatureKey);
            signer.update(sadTbs);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IOException(e);
        }
    }

    private BNotKHelper() {
    }
}

