/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.data;

import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class BNotKSadTbs
implements ASN1Encodable {
    byte[] token;
    String keyId;
    AlgorithmIdentifier hashAlgorithm;
    List<byte[]> tbsHashValues;

    public BNotKSadTbs(byte[] token, String keyId, AlgorithmIdentifier hashAlgorithm, List<byte[]> tbsHashValues) {
        this.token = token;
        this.keyId = keyId;
        this.hashAlgorithm = hashAlgorithm;
        this.tbsHashValues = tbsHashValues;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector hashValues = new ASN1EncodableVector();
        for (byte[] hash : this.tbsHashValues) {
            hashValues.add((ASN1Encodable)new DEROctetString(hash));
        }
        return new DERSequence(new ASN1Encodable[]{ASN1Sequence.getInstance((Object)this.token), new DERUTF8String(this.keyId), this.hashAlgorithm, new DERSequence(hashValues)});
    }
}

