/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BNotKRemoteCertificate {
    private static final String TYPE_HSM_WRAPPED_KEY = "hsm-wrapped-key";
    private List<Link> links = new ArrayList<Link>();
    private byte[] value;

    public String findKeyId() {
        for (Link link : this.links) {
            if (!TYPE_HSM_WRAPPED_KEY.equals(link.type)) continue;
            return link.id;
        }
        throw new IllegalStateException("not a valid remote signature certificate entry");
    }

    public Certificate getCertificate() throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(this.getValue()));
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    static class Link {
        private String id;
        private String type;

        Link() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

