/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.bos_bremen.common.HexUtil;
import de.governikus.csl.remote.sign.bnotk.BNotKClientConfiguration;
import de.governikus.csl.remote.sign.bnotk.base.BNotKAuthenticator;
import de.governikus.csl.remote.sign.bnotk.data.BNotKRemoteCertificate;
import de.governikus.csl.remote.sign.bnotk.data.BNotKSadTbs;
import de.governikus.csl.remote.sign.bnotk.data.BNotKSignatureActivationData;
import de.governikus.csl.remote.sign.bnotk.util.BNotKHelper;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.jce.remote.RemoteSignaturePrivateKey;
import de.governikus.csl.uom.res.KeyFunction;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.util.Environment;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNotKRemoteSignaturePrivateKey
implements RemoteSignaturePrivateKey {
    private static final Logger LOG = LoggerFactory.getLogger(BNotKRemoteSignaturePrivateKey.class);
    private static final long serialVersionUID = 1L;
    private final transient BNotKAuthenticator bnotkAuthenticator;
    private final transient PrivateKeyResourceReference privateKeyResourceReference;
    private final transient BNotKRemoteCertificate remoteCertificate;

    public BNotKRemoteSignaturePrivateKey(BNotKRemoteCertificate remoteCertificate, PrivateKeyResourceReference privateKeyResourceReference, BNotKAuthenticator bnotkAuthenticator) {
        this.remoteCertificate = remoteCertificate;
        this.privateKeyResourceReference = privateKeyResourceReference;
        this.bnotkAuthenticator = bnotkAuthenticator;
    }

    private void checkAlgorithms(String signatureAlgorithmURI, String digestAlgorithmURI) throws CSLJCERemoteSignatureException {
        LOG.info("signatureAlgorithmURI: {}", (Object)signatureAlgorithmURI);
        if (!signatureAlgorithmURI.contains(this.getAlgorithm().toLowerCase(Locale.ENGLISH))) {
            throw new CSLJCERemoteSignatureException("invalid key - signature algorithm not usable with key, key and signature algorithm mismatch: key algorithm - " + this.getAlgorithm() + ", signature algorithm - " + signatureAlgorithmURI);
        }
        Optional<KeyFunctionSupportedAlgorithms> supportedSignatureAlgorithms = this.privateKeyResourceReference.getKeyFunctionSupportedAlgorithms().stream().filter(a -> a.getKeyFunction() == KeyFunction.SIGN).findAny();
        if (!supportedSignatureAlgorithms.isPresent()) {
            throw new CSLJCERemoteSignatureException("invalid signature algorithm - signature algorithm not usable with key, key and signature algorithm mismatch: key algorithm - " + signatureAlgorithmURI + ", no signature algorithm supported");
        }
        if (!supportedSignatureAlgorithms.get().getSupportedAlgorithms().contains(signatureAlgorithmURI)) {
            throw new CSLJCERemoteSignatureException("invalid signature algorithm - signature algorithm not usable with key, key and signature algorithm mismatch: signature algorithm - " + signatureAlgorithmURI + ", supported signature algorithms " + supportedSignatureAlgorithms.get().getSupportedAlgorithms());
        }
        LOG.info("digestAlgorithmURI: {}", (Object)digestAlgorithmURI);
    }

    private BNotKSignatureActivationData generateBNotKSignatureActivationData(byte[] digestValue) throws IOException {
        byte[] token = this.bnotkAuthenticator.getToken();
        String keyId = this.remoteCertificate.findKeyId();
        BNotKSadTbs sadTbs = new BNotKSadTbs(token, keyId, new DefaultDigestAlgorithmIdentifierFinder().find("SHA256"), Arrays.asList(new byte[][]{digestValue}));
        byte[] sadSignature = BNotKHelper.generateSadSignature(this.bnotkAuthenticator.getSadKeyPair().getPrivate(), sadTbs.toASN1Primitive().getEncoded());
        return new BNotKSignatureActivationData(sadTbs, sadSignature);
    }

    public String getAlgorithm() {
        return this.privateKeyResourceReference == null ? null : this.privateKeyResourceReference.getAlgorithm();
    }

    public byte[] getEncoded() {
        throw new IllegalStateException("access to encoded private key is impossible for a remote private key");
    }

    public String getFormat() {
        return "PKCS#8";
    }

    private void logTime(String message, Instant start, Instant finish) {
        if (LOG.isInfoEnabled() && (start == null || finish == null)) {
            LOG.info("{} time measurement failed", (Object)message);
        }
        long fulltimeElapsedSeconds = Duration.between(start, finish).toSeconds();
        long fulltimeElapsedMillis = Duration.between(start, finish).toMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info("{} {} s, {} ms", new Object[]{message, fulltimeElapsedSeconds, fulltimeElapsedMillis});
        }
    }

    public synchronized byte[] sign(String signatureAlgorithmURI, String digestAlgorithmURI, byte[] digestValue, Environment environment) throws CSLJCERemoteSignatureException {
        byte[] byArray;
        if (this.bnotkAuthenticator == null) {
            throw new CSLJCERemoteSignatureException("remote signature private key already destroyed and not usable anymore");
        }
        Instant startComplete = Instant.now();
        Instant startTransport = null;
        Instant finishTransport = null;
        try {
            this.checkAlgorithms(signatureAlgorithmURI, digestAlgorithmURI);
            if (LOG.isDebugEnabled()) {
                LOG.debug("remote signature private key digest value: {}", (Object)HexUtil.hexify((byte[])digestValue));
            }
            BNotKSignatureActivationData sad = this.generateBNotKSignatureActivationData(digestValue);
            BNotKClientConfiguration bNotKClientConfiguration = this.bnotkAuthenticator.getBNotKClientConfiguration();
            startTransport = Instant.now();
            HttpResponse httpResponse = bNotKClientConfiguration.getHttpFacade().post(URI.create(bNotKClientConfiguration.getUrlSignServerSigningRequest()), (HttpRequest)new ByteArrayRequest(sad.toASN1Primitive().getEncoded()), new HttpHeader("Content-Type", "application/octet-stream"), new HttpHeader("Accept", "application/json"));
            finishTransport = Instant.now();
            byte[] jsonSignatures = BNotKHelper.checkResponse(httpResponse, "request remote signature failed");
            byte[][] signatures = (byte[][])new ObjectMapper().readValue(jsonSignatures, byte[][].class);
            LOG.info("signatures received: {}", (Object)signatures.length);
            byArray = signatures[0];
        }
        catch (Exception e) {
            try {
                throw new CSLJCERemoteSignatureException((Throwable)e);
            }
            catch (Throwable throwable) {
                Instant finishComplete = Instant.now();
                this.logTime("remote signature complete time:", startComplete, finishComplete);
                this.logTime("remote signature transport time:", startTransport, finishTransport);
                throw throwable;
            }
        }
        Instant finishComplete = Instant.now();
        this.logTime("remote signature complete time:", startComplete, finishComplete);
        this.logTime("remote signature transport time:", startTransport, finishTransport);
        return byArray;
    }
}

