/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.governikus.csl.remote.sign.bnotk.BNotKClientConfiguration;
import de.governikus.csl.remote.sign.bnotk.BNotKServiceConstants;
import de.governikus.csl.remote.sign.bnotk.base.BNotKAuthenticator;
import de.governikus.csl.remote.sign.bnotk.base.BNotKRemoteSignaturePrivateKey;
import de.governikus.csl.remote.sign.bnotk.data.BNotKRemoteCertificate;
import de.governikus.csl.remote.sign.bnotk.util.BNotKHelper;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceReferenceImpl;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNotKKeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(BNotKKeyManager.class);
    private final BNotKAuthenticator bnotkAuthenticator;
    private final List<PrivateKeyResource> privateKeyResources = new ArrayList<PrivateKeyResource>();

    public BNotKKeyManager(BNotKAuthenticator bnotkAuthenticator) {
        this.bnotkAuthenticator = bnotkAuthenticator;
    }

    private PrivateKeyResource createResource(PrivateKeyResourceReference privateKeyResourceReference, BNotKRemoteSignaturePrivateKey privateKey) {
        return new PrivateKeyResourceImpl(privateKeyResourceReference, (PrivateKey)((Object)privateKey), true, "BC");
    }

    private PrivateKeyResourceReference createResourceReference(BNotKRemoteCertificate remoteCertificate) throws IOException {
        try {
            return new PrivateKeyResourceReferenceImpl("BNotK-Remote-" + remoteCertificate.findKeyId(), ResourceType.KEY, ResourceComponentType.HSM, ResourceAreaType.REMOTE, PrivateKeyResourceImpl.class.getName(), ResourceConstants.SIMPLE_RESOURCE_REFERENCE_STATE, Collections.singletonList(remoteCertificate.getCertificate()), BNotKServiceConstants.DEFAULT_REMOTE_KEY_SUPPORTED_RSA_SIGNATURE_ALGORITHMS);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    public PrivateKeyResource getPrivateKeyResource() throws IOException {
        return this.getPrivateKeyResources().get(0);
    }

    public synchronized List<PrivateKeyResource> getPrivateKeyResources() throws IOException {
        if (this.privateKeyResources.isEmpty()) {
            List<BNotKRemoteCertificate> remoteCertificates = this.getRemoteCertificates();
            for (BNotKRemoteCertificate remoteCertificate : remoteCertificates) {
                PrivateKeyResourceReference privateKeyResourceReference = this.createResourceReference(remoteCertificate);
                this.privateKeyResources.add(this.createResource(privateKeyResourceReference, new BNotKRemoteSignaturePrivateKey(remoteCertificate, privateKeyResourceReference, this.bnotkAuthenticator)));
            }
        }
        return this.privateKeyResources;
    }

    private List<BNotKRemoteCertificate> getRemoteCertificates() throws IOException {
        ObjectMapper json;
        BNotKRemoteCertificate[] remoteKeys;
        byte[] idpToken = this.bnotkAuthenticator.getToken();
        BNotKClientConfiguration bnotkClientConfiguration = this.bnotkAuthenticator.getBNotKClientConfiguration();
        long now = System.currentTimeMillis();
        String query = "application=RemoteSignature&not-before;notAfter=" + now + "&not-after;notBefore=" + now;
        HttpResponse httpResponse = bnotkClientConfiguration.getHttpFacade().get(URI.create(bnotkClientConfiguration.getUrlKeyManagerCertificatesRequest() + query), new HttpHeader("Accept", "application/json"), new HttpHeader("Authorization", "Bearer " + Base64.getEncoder().encodeToString(idpToken)));
        byte[] jsonKeyList = BNotKHelper.checkResponse(httpResponse, "request remote certificates failed");
        if (LOG.isInfoEnabled()) {
            LOG.info("retreived json keys response: {}", (Object)new String(jsonKeyList, StandardCharsets.UTF_8));
        }
        if ((remoteKeys = (BNotKRemoteCertificate[])(json = new ObjectMapper()).readValue(jsonKeyList, BNotKRemoteCertificate[].class)).length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(remoteKeys);
    }
}

