/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.governikus.csl.remote.sign.bnotk.BNotKCardHandler;
import de.governikus.csl.remote.sign.bnotk.BNotKClientConfiguration;
import de.governikus.csl.remote.sign.bnotk.data.BNotKTokenAugmentationRequest;
import de.governikus.csl.remote.sign.bnotk.util.BNotKHelper;
import de.governikus.csl.remote.sign.bnotk.util.BNotKMCardHelper;
import de.governikus.csl.remote.sign.bnotk.util.BNotKTokenHelper;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import java.io.IOException;
import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNotKAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(BNotKAuthenticator.class);
    private static final Duration SECURITY_DURATION_EXPIRATION = Duration.ofMinutes(5L);
    private static final byte[] TOKEN_REQUESTS_CANCELLED = null;
    private final BNotKClientConfiguration bnotkClientConfiguration;
    private final OCFPrivateKey ocfPrivateKey;
    private final GovCS cardService;
    private final Card card;
    private final BNotKCardHandler cardHandler;
    private final KeyPair sadKeyPair;
    private ZonedDateTime tokenExpirationDate;
    private Map<TokenType, byte[]> tokenMap;

    public BNotKAuthenticator(OCFPrivateKey ocfPrivateKey) throws IOException {
        this(ocfPrivateKey, new BNotKClientConfiguration());
    }

    public BNotKAuthenticator(OCFPrivateKey ocfPrivateKey, BNotKClientConfiguration bnotkClientConfiguration) throws IOException {
        OCFPrivateKey lOcfPrivateKey = BNotKMCardHelper.requiresBNotKOCFPrivateKey((Key)ocfPrivateKey);
        GovCS lCardService = lOcfPrivateKey.getCardService();
        Card lCard = lCardService.getCardObject();
        if (bnotkClientConfiguration != null && bnotkClientConfiguration.getCardHandler() != null && !bnotkClientConfiguration.getCardHandler().useInsertedCard(lCard)) {
            throw new IllegalArgumentException("card application denies using card: " + lCard);
        }
        this.ocfPrivateKey = BNotKMCardHelper.requiresBNotKOCFPrivateKey((Key)lOcfPrivateKey);
        this.cardService = this.ocfPrivateKey.getCardService();
        this.card = this.cardService.getCardObject();
        this.bnotkClientConfiguration = bnotkClientConfiguration == null ? new BNotKClientConfiguration() : bnotkClientConfiguration;
        this.cardHandler = this.bnotkClientConfiguration.getCardHandler();
        this.sadKeyPair = BNotKHelper.generateSADKeyPair();
    }

    public BNotKClientConfiguration getBNotKClientConfiguration() {
        return this.bnotkClientConfiguration;
    }

    public KeyPair getSadKeyPair() {
        return this.sadKeyPair;
    }

    public synchronized byte[] getToken() {
        if (this.tokenExpirationDate == null || ZonedDateTime.now().isAfter(this.tokenExpirationDate)) {
            this.requestToken();
        }
        return this.tokenMap.get((Object)TokenType.AUGMENTED);
    }

    private byte[] requestAugmentedToken(byte[] initialToken) throws IOException {
        HttpResponse httpResponse = this.bnotkClientConfiguration.getHttpFacade().post(URI.create(this.bnotkClientConfiguration.getUrlIdpAugmentedTokenRequest()), (HttpRequest)new ByteArrayRequest(new ObjectMapper().writeValueAsBytes((Object)new BNotKTokenAugmentationRequest(initialToken, this.sadKeyPair.getPublic().getEncoded()))), new HttpHeader("Content-Type", "application/json"), new HttpHeader("Accept", "application/octet-stream"));
        return BNotKHelper.checkResponse(httpResponse, "request augment token failed");
    }

    private Map<TokenType, byte[]> requestIdpTokens() throws IOException {
        EnumMap<TokenType, byte[]> lTokenMap = new EnumMap<TokenType, byte[]>(TokenType.class);
        LOG.info("get token");
        byte[] initialToken = this.requestInitialToken();
        if (TOKEN_REQUESTS_CANCELLED == initialToken) {
            return lTokenMap;
        }
        lTokenMap.put(TokenType.INITIAL, initialToken);
        boolean successTokenRequest = initialToken.length > 0;
        LOG.info("successful received server token response: {}", (Object)successTokenRequest);
        if (successTokenRequest) {
            boolean successAugmentedTokenRequest;
            LOG.info("step 1: token received");
            byte[] augmentedToken = this.requestAugmentedToken(initialToken);
            boolean bl = successAugmentedTokenRequest = augmentedToken != null && augmentedToken.length > 0;
            if (successAugmentedTokenRequest) {
                LOG.info("successful received server augmented token response: {}", (Object)successAugmentedTokenRequest);
                lTokenMap.put(TokenType.AUGMENTED, augmentedToken);
                this.tokenExpirationDate = BNotKTokenHelper.getValidToDate(augmentedToken).minus(SECURITY_DURATION_EXPIRATION);
                if (this.cardHandler != null) {
                    this.cardHandler.tokenUpdated(this.tokenExpirationDate);
                }
            }
        }
        return lTokenMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] requestInitialToken() throws IOException {
        byte[] initialToken;
        boolean transactionStartedLocally = false;
        try {
            boolean transactionStartedExternally = this.cardService.isTransactionStarted();
            LOG.info("transaction started externally: {}", (Object)transactionStartedExternally);
            if (!transactionStartedExternally) {
                if (this.tokenMap == null && this.cardHandler != null && this.cardHandler.shouldPinBeEntered(this.card)) {
                    transactionStartedLocally = this.cardService.beginTransaction();
                } else if (this.tokenMap == null && this.cardHandler == null || this.cardHandler != null && this.cardHandler.shouldPinBeEntered(this.card)) {
                    transactionStartedLocally = this.cardService.beginTransaction();
                } else if (this.cardHandler == null) {
                    transactionStartedLocally = this.cardService.beginTransaction();
                } else {
                    byte[] byArray = TOKEN_REQUESTS_CANCELLED;
                    return byArray;
                }
            }
            BNotKMCardHelper.initCardKey(this.ocfPrivateKey);
            initialToken = this.requestInitialTokenRaw();
        }
        finally {
            if (transactionStartedLocally) {
                this.cardService.endTransaction(transactionStartedLocally);
            }
        }
        return initialToken;
    }

    private byte[] requestInitialTokenRaw() throws IOException {
        HttpResponse httpResponse = this.bnotkClientConfiguration.getHttpFacade().deriveBNotK("BCJSSE", BNotKMCardHelper.getMCardKeyStore()).get(URI.create(this.bnotkClientConfiguration.getUrlIdpInitialTokenRequest()), new HttpHeader[0]);
        return BNotKHelper.checkResponse(httpResponse, "request initial token failed");
    }

    private void requestToken() {
        try {
            this.tokenMap = this.requestIdpTokens();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to get tokens: " + e.getMessage(), e);
        }
    }

    public ZonedDateTime getTokenExpirationDate() {
        return this.tokenExpirationDate;
    }

    static enum TokenType {
        AUGMENTED,
        INITIAL;

    }
}

