/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.bnotk;

import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.governikus.csl.remote.sign.bnotk.BNotKClientConfiguration;
import de.governikus.csl.remote.sign.bnotk.base.BNotKAuthenticator;
import de.governikus.csl.remote.sign.bnotk.base.BNotKKeyManager;
import de.governikus.csl.remote.sign.bnotk.util.BNotKHelper;
import de.governikus.csl.remote.sign.bnotk.util.BNotKMCardHelper;
import de.governikus.csl.uom.res.PrivateKeyResource;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNotKRemoteSignature {
    private static final Logger LOG = LoggerFactory.getLogger(BNotKRemoteSignature.class);
    private final BNotKAuthenticator bnotkAuthenticator;
    private final BNotKKeyManager bnotkKeyManager;

    public BNotKRemoteSignature(OCFPrivateKey ocfPrivateKey, BNotKClientConfiguration bnotkClientConfiguration) throws IOException {
        BNotKHelper.assertValidProviderOrderForTLS();
        this.bnotkAuthenticator = new BNotKAuthenticator(ocfPrivateKey, bnotkClientConfiguration);
        this.bnotkKeyManager = new BNotKKeyManager(this.bnotkAuthenticator);
        LOG.info("BNotKRemoteSignature created");
    }

    public BNotKRemoteSignature(PrivateKeyResource privateKeyResource, BNotKClientConfiguration bnotkClientConfiguration) throws IOException {
        this(BNotKMCardHelper.requiresBNotKOCFPrivateKey(privateKeyResource), bnotkClientConfiguration);
    }

    public PrivateKeyResource getPrivateKeyResource() throws IOException {
        return this.bnotkKeyManager.getPrivateKeyResource();
    }

    public List<PrivateKeyResource> getPrivateKeyResources() throws IOException {
        return this.bnotkKeyManager.getPrivateKeyResources();
    }

    public ZonedDateTime getTokenExpirationDate() {
        return this.bnotkAuthenticator.getTokenExpirationDate();
    }
}

