/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.Null;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSModuleNamespaceObject
extends JSNonProxyObject {
    private final AbstractModuleRecord module;
    private final UnmodifiableEconomicMap<TruffleString, ExportResolution> exports;

    protected JSModuleNamespaceObject(Shape shape, AbstractModuleRecord module, UnmodifiableEconomicMap<TruffleString, ExportResolution> exports) {
        super(shape, Null.instance);
        this.module = module;
        this.exports = exports;
    }

    public AbstractModuleRecord getModule() {
        return this.module;
    }

    public UnmodifiableEconomicMap<TruffleString, ExportResolution> getExports() {
        return this.exports;
    }

    public static JSModuleNamespaceObject create(JSRealm realm, JSObjectFactory factory, AbstractModuleRecord module, UnmodifiableEconomicMap<TruffleString, ExportResolution> exports) {
        return factory.initProto(new JSModuleNamespaceObject(factory.getShape(realm), module, exports), realm);
    }

    @Override
    public TruffleString getClassName() {
        return JSModuleNamespace.CLASS_NAME;
    }

    @Override
    public boolean setPrototypeOf(JSDynamicObject newPrototype) {
        return newPrototype == Null.instance;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean testIntegrityLevel(boolean frozen) {
        return this.testIntegrityLevel(frozen, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(boolean freeze, boolean doThrow) {
        return this.testIntegrityLevel(freeze, true);
    }

    private boolean testIntegrityLevel(boolean frozen, boolean doThrow) {
        for (ExportResolution binding : this.getExports().getValues()) {
            JSModuleNamespace.getBindingValue(binding);
            if (!frozen) continue;
            if (doThrow) {
                throw Errors.createTypeError("not allowed to freeze a namespace object");
            }
            return false;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return Strings.addBrackets(JSModuleNamespace.CLASS_NAME);
    }
}

