/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jaxb;

import de.governikus.csl.uom.output.SchemaConformityReport;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;

public class SchemaConformityReportValidationEventHandler
implements ValidationEventHandler {
    private MajorTotalResult majorResult = MajorTotalResult.TOTAL_PASSED;
    private StringBuilder sb = new StringBuilder();

    public boolean handleEvent(ValidationEvent event) {
        if (event != null) {
            switch (event.getSeverity()) {
                case 0: {
                    this.sb.append("WARNING: ");
                    this.majorResult = MajorTotalResult.max((MajorTotalResult)this.majorResult, (MajorTotalResult)MajorTotalResult.INDETERMINATE);
                    break;
                }
                case 1: {
                    this.sb.append("ERROR: ");
                    this.majorResult = MajorTotalResult.max((MajorTotalResult)this.majorResult, (MajorTotalResult)MajorTotalResult.TOTAL_FAILED);
                    break;
                }
                case 2: {
                    this.sb.append("FATAL ERROR: ");
                    this.majorResult = MajorTotalResult.max((MajorTotalResult)this.majorResult, (MajorTotalResult)MajorTotalResult.TOTAL_FAILED);
                    break;
                }
            }
            this.sb.append(event.getMessage());
            this.sb.append("\n");
        }
        return true;
    }

    public SchemaConformityReport getReport() {
        return new SchemaConformityReport(this.majorResult, this.majorResult != MajorTotalResult.TOTAL_PASSED ? this.sb.toString() : null);
    }
}

