/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jaxb;

import de.governikus.csl.jaxb.SchemaConformityReportValidationEventHandler;
import de.governikus.csl.uom.output.SchemaConformityReport;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;

public interface JAXBContextHolder<T> {
    public JAXBContext getContext();

    public T getObjectFactory();

    default public byte[] marshal(Object value, boolean indent) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.marshal(value, baos, indent);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    default public void marshal(Object value, OutputStream os, boolean indent) throws IOException {
        this.marshal(value, os, indent, null);
    }

    default public SchemaConformityReport marshal(Object value, OutputStream os, boolean indent, Schema schema) throws IOException {
        try {
            SchemaConformityReportValidationEventHandler schemaConformityHandler = null;
            Marshaller marshaller = this.getContext().createMarshaller();
            if (schema != null) {
                marshaller.setSchema(schema);
                schemaConformityHandler = new SchemaConformityReportValidationEventHandler();
                marshaller.setEventHandler((ValidationEventHandler)schemaConformityHandler);
            }
            DOMResult domResult = new DOMResult();
            marshaller.marshal(value, (Result)domResult);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)transformerFactory);
            Transformer transformer = transformerFactory.newTransformer();
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            transformer.transform(new DOMSource(domResult.getNode()), new StreamResult(os));
            if (schemaConformityHandler == null) {
                return new SchemaConformityReport(MajorTotalResult.NOT_VALIDATED);
            }
            return schemaConformityHandler.getReport();
        }
        catch (JAXBException | TransformerException e) {
            throw new IOException(e);
        }
    }

    default public <O> O unmarshal(InputStream is, Class<O> declaredType) throws IOException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((XMLInputFactory)xif);
            XMLStreamReader xsr = xif.createXMLStreamReader(is);
            Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
            Object o = unmarshaller.unmarshal(xsr);
            if (o instanceof JAXBElement) {
                JAXBElement elem = (JAXBElement)o;
                o = elem.getValue();
            }
            return declaredType.cast(o);
        }
        catch (ClassCastException | JAXBException | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    default public <O> O unmarshal(byte[] value, Class<O> declaredType) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(value);){
            O o = this.unmarshal(is, declaredType);
            return o;
        }
    }
}

