/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jaxb;

import de.governikus.csl.uom.ResourceUtil;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class BaseSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSchemaValidator.class);
    private Schema schema;
    protected Class<?>[] boundClasses;
    private ErrorHandler errorHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseSchemaValidator(String[] schemata, Class<?> ... classes) throws SAXException {
        this.boundClasses = classes;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SecurityUtils.protectFactoryAgainstXXE((SchemaFactory)schemaFactory);
        Source[] sources = new Source[schemata.length];
        InputStream[] streams = new InputStream[schemata.length];
        try {
            for (int i = 0; i < schemata.length; ++i) {
                streams[i] = ResourceUtil.getResourceAsStream((String)schemata[i]);
                sources[i] = new StreamSource(streams[i]);
            }
            this.schema = schemaFactory.newSchema(sources);
        }
        finally {
            for (InputStream is : streams) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.info("Can't close stream, potential resource leak!", (Throwable)e);
                }
            }
        }
    }

    protected Schema getSchema() {
        return this.schema;
    }

    protected abstract JAXBContext getJAXBContext() throws JAXBException;

    public void validateFile(File path) throws SAXException, IOException {
        this.validateSource(new StreamSource(path));
    }

    public void validateSource(Source source) throws SAXException, IOException {
        Validator validator = this.schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        if (this.errorHandler != null) {
            validator.setErrorHandler(this.errorHandler);
        }
        validator.validate(source);
    }

    public void validateStream(InputStream is) throws SAXException, IOException {
        this.validateSource(new StreamSource(is));
    }

    public void validateRaw(byte[] data) throws SAXException, IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            this.validateStream(bais);
        }
    }

    protected void validateObject(Object o) throws JAXBException, IOException, SAXException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.marshal(o, (OutputStream)baos);
            this.validateRaw(baos.toByteArray());
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

